package com.ruiwenliu.wrapper.base.presenter;

import com.frame.rv.config.CommonApi;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.SPConstance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.presenter.MvpPresenter;
import com.rv.component.utils.Cookie;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Created by Amuse
 * Date:2019/3/4.
 * Desc:
 */

public class CommonPresenter extends MvpPresenter {

    @Override
    /**
     * 域名地址
     */
    public String getBaseUrl() {
        return RvFrameConfig.AUTH_POST;
    }

    /**
     * 行为记录保存
     *
     * @param type   行为类型
     * @param typeid 活动id
     */
    public void saveOnclick(String type, String typeid) {
        Map<String, Object> headMap = new LinkedHashMap<>();
        headMap.put("Content-type", "application/json;charset=UTF-8");

        String customertype = "";
        String customerid = "";
        if (OkGoUtil.getToken() != null) {
            headMap.put("Authorization", OkGoUtil.getToken());
            customertype = "2";  // 1是游客 2是用户
        } else {
            customerid = OkGoUtil.getYkId();
            customertype = "1";
        }
//        postBodyData(RvFrameConfig.HOST, 20,CommonApi.RVENTHUSIAST_APP_UNAUTH_SAVE,BaseBean.class, new SaveOnClick(customertype, customerid, type, typeid), headMap,false);
        postBodyData2(RvFrameConfig.HOST, CommonApi.RVENTHUSIAST_APP_UNAUTH_SAVE, new SaveOnClick(customertype, customerid, type, typeid), headMap);
    }


    private class SaveOnClick {
        private String customerType;
        private String customerId;
        private String type;
        private String typeId;

        public SaveOnClick(String customerType, String customerId, String type, String typeId) {
            this.customerType = customerType;
            this.customerId = customerId;
            this.type = type;
            this.typeId = typeId;
        }

        public String getCustomerType() {
            return customerType;
        }

        public void setCustomerType(String customerType) {
            this.customerType = customerType;
        }

        public String getCustomerId() {
            return customerId;
        }

        public void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTypeId() {
            return typeId;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }
    }

}


