package com.base.utils.tools.android;

import android.content.Context;
import android.content.SharedPreferences;

import com.base.utils.Config;

/**
 * 键值对存储
 */
public class SPUtil {
    private static final String APP_NAME = Config.spName;

    public static final String APP_LANGUAGE = Config.spLanguage;
    public static final String APP_LANGUAGE_ZH = "zh";
    public static final String APP_LANGUAGE_EN = "en";



    /**
     * 设置中文标记
     */
    public static void setAppLanguageChinese(Context context) {
        setString(context,APP_LANGUAGE, APP_LANGUAGE_ZH);
    }

    /**
     * 设置英文标记
     */
    public static void setAppLanguageEnglish(Context context) {
        setString(context,APP_LANGUAGE, APP_LANGUAGE_EN);
    }


    /**
     * 获取语言标记
     */
    public static String getAppLanguageString(Context context) {
        return getString(context,APP_LANGUAGE);
    }

    /**
     * 设置语言标记
     */
    public static void setAppLanguageString(Context context,String language) {
      setString(context,APP_LANGUAGE,language);
    }

    public static void setInt(Context context, String key, int value) {
        SharedPreferences sp = context.getSharedPreferences(APP_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt(key, value);
        editor.apply();
        editor.commit();
    }

    public static int getInt(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(APP_NAME, Context.MODE_PRIVATE);
        return sp.getInt(key, -1);
    }


    public static void setFloat(Context context, String key, float value) {
        SharedPreferences sp = context.getSharedPreferences(APP_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.putFloat(key, value);
        editor.apply();
        editor.commit();
    }

    public static float getFloat(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(APP_NAME, Context.MODE_PRIVATE);
        return sp.getFloat(key, -1F);
    }

    public static void setLong(Context context, String key, long value) {
        SharedPreferences sp = context.getSharedPreferences(APP_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.putLong(key, value);
        editor.apply();
        editor.commit();
    }

    public static float getLong(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(APP_NAME, Context.MODE_PRIVATE);
        return sp.getLong(key,-1L);
    }


    public static void setString(Context context, String key, String value) {
        SharedPreferences sp = context.getSharedPreferences(APP_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(key, value);
        editor.apply();
        editor.commit();
    }

    public static String getString(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(APP_NAME, Context.MODE_PRIVATE);
        return sp.getString(key, null);
    }

    public static void setBoolean(Context context, String key, boolean value) {
        SharedPreferences sp = context.getSharedPreferences(APP_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean(key, value);
        editor.apply();
        editor.commit();
    }

    public static boolean getBoolean(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(APP_NAME, Context.MODE_PRIVATE);
        return sp.getBoolean(key, false);
    }

}