package com.base.utils.tools.android;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.widget.Toast;

import com.base.utils.R;

/**
 * 复制内容到剪贴版
 * Created by YUYIFE on 2018/9/12.
 */

public class ClipboardUtil {
    public static void setText(Context baseContext, String text) {
        //从API11开始android推荐使用android.content.ClipboardManager
        //为了兼容低版本我们这里使用旧版的android.text.ClipboardManager，虽然提示deprecated，但不影响使用。
        ClipboardManager cm = (ClipboardManager) baseContext.getSystemService(Context.CLIPBOARD_SERVICE);
        //将文本内容放到系统剪贴板里。
//      //老的API，被弃用
//        if (cm != null) {
//            cm.setText(text);
//        } else {
//            Toast.makeText(baseContext, "Exception:ClipboardManager==null", Toast.LENGTH_SHORT).show();
//        }
        //创建ClipData对象
        ClipData clipData = ClipData.newPlainText(text, text);
        //添加ClipData对象到剪切板中
        if (cm != null) {
            cm.setPrimaryClip(clipData);
            Toast.makeText(baseContext, baseContext.getString(R.string.prompt_copy_success), Toast.LENGTH_SHORT).show();
        } else {
            Toast.makeText(baseContext, baseContext.getString(R.string.prompt_copy_fail), Toast.LENGTH_SHORT).show();
        }
    }
}
