package com.base.utils.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.app.Fragment;
import android.widget.Toast;

import com.base.sweetdialog.SweetDialogUtil;
import com.base.utils.R;
import com.base.utils.interf.OnInit;
import com.base.utils.ui.snack.TopSnackBarUtil;

import java.io.Serializable;
import java.util.Map;

import cn.pedant.SweetAlert.SweetAlertDialog;


public abstract class BaseFragment extends Fragment implements OnInit, Serializable {
    protected Context baseContext;

    protected Map<String, String> map;

    public Map<String, String> getMap() {
        return map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }


    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.baseContext = context;
    }

    public void showToastShort(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(baseContext, txt, Toast.LENGTH_SHORT).show();
            }
        });
    }

    public void showToastLong(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(baseContext, txt, Toast.LENGTH_LONG).show();
            }
        });
    }

    public void showSuccessShort(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                TopSnackBarUtil.showSuccessShort(getActivity(), txt);
            }
        });
    }

    public void showWarnLong(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                TopSnackBarUtil.showWarnLong(getActivity(), txt);
            }
        });
    }

    public void showWarnShort(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                TopSnackBarUtil.showWarnShort(getActivity(), txt);
            }
        });
    }

    public void showErrorShort(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                TopSnackBarUtil.showErrorShort(getActivity(), txt);
            }
        });
    }

    public void showErrorLong(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                TopSnackBarUtil.showErrorLong(getActivity(), txt);
            }
        });
    }

    @SuppressLint("StaticFieldLeak")
    protected static SweetAlertDialog sweetAlertDialog;

    /**
     * 警示对话框
     */
    public void showSweetWarnDialog(final String title, final SweetAlertDialog.OnSweetClickListener confirmListener) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                dismissSweetDialog();
                sweetAlertDialog = SweetDialogUtil.getWarningDialog(baseContext);
                sweetAlertDialog.setTitleText(title)
                        .setContentText(null)
                        .setCancelText(getString(R.string.resource_public_cancel))
                        .setCancelClickListener(null)
                        .setConfirmText(getString(R.string.resource_public_confirm))
                        .setConfirmClickListener(confirmListener)
                        .show();
            }
        });

    }

    /**
     * 等待的提示
     */
    public void showSweetProgressDialog(final String title) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                dismissSweetDialog();
                sweetAlertDialog = SweetDialogUtil.getProgressDialog(baseContext);
                sweetAlertDialog.setTitleText(title).setContentText(null).show();
            }
        });
    }

    /**
     * 失败的提示
     */
    public void showSweetErrorDialog(final String content) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                dismissSweetDialog();
                sweetAlertDialog = SweetDialogUtil.getErrorDialog(baseContext);
                sweetAlertDialog.setTitleText(null)
                        .setContentText(content)
                        .setConfirmText(getString(R.string.resource_public_know))
                        .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                            @Override
                            public void onClick(SweetAlertDialog sweetAlertDialog) {
                                sweetAlertDialog.dismissWithAnimation();
                            }
                        }).show();
            }
        });
    }

    /**
     * 成功的提示
     */
    public void showSweetSuccessDialog(final String title) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                dismissSweetDialog();
                sweetAlertDialog = SweetDialogUtil.getSuccessDialog(baseContext);
                sweetAlertDialog.setTitleText(title)
                        .setConfirmText(getString(R.string.resource_public_ok))
                        .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                            @Override
                            public void onClick(SweetAlertDialog sweetAlertDialog) {
                                sweetAlertDialog.dismissWithAnimation();
                            }
                        }).show();
            }
        });
    }

    /**
     * 成功的提示  并在1秒后关闭
     */
    public void showSweetSuccessDialogAndDelayClose(final String title) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                dismissSweetDialog();
                sweetAlertDialog = SweetDialogUtil.getSuccessDialog(baseContext);
                sweetAlertDialog.setTitleText(title)
                        .setConfirmText(getString(R.string.resource_public_ok))
                        .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                            @Override
                            public void onClick(SweetAlertDialog sweetAlertDialog) {
                                sweetAlertDialog.dismissWithAnimation();
                            }
                        }).show();
                BaseApp.getMainHandler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        dismissSweetDialog();
                    }
                }, 1000);
            }
        });
    }

    public void dismissSweetDialog() {
        if (sweetAlertDialog != null) {
            BaseApp.getMainHandler().post(new Runnable() {
                @Override
                public void run() {
                    if (sweetAlertDialog != null) {
                        sweetAlertDialog.dismissWithAnimation();
                        sweetAlertDialog = null;
                    }
                }
            });
        }
    }
}
