package com.base.utils.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Toast;

import com.base.sweetdialog.SweetDialogUtil;
import com.base.utils.Config;
import com.base.utils.R;
import com.base.utils.interf.OnInit;
import com.base.utils.tools.android.ActivityUtil;
import com.base.utils.tools.android.IntentUtil;
import com.base.utils.tools.android.ScreenShotUtil;
import com.base.utils.tools.android.StatusBarUtil;
import com.base.utils.ui.snack.TopSnackBarUtil;

import cn.pedant.SweetAlert.SweetAlertDialog;

/**
 * 注意
 * 当用IntentUtil.startActivity的时候，统一intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
 * 所以在清单文件里声明Activity的时候，应launchMode="singleTask"
 */
public abstract class BaseActivity extends AppCompatActivity implements OnInit {
    protected Context baseContext;

    @Override
    protected void onResume() {
        super.onResume();
        ActivityUtil.setAppIsBackground(baseContext, false);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        baseContext = this;
        if (Config.isScreenFull) {
            StatusBarUtil.setFullScreen(this, true);
            StatusBarUtil.hideSystemUI(this);
        }
        //如果打开else的话，需要在子Activity布局的root parent 设置
        //android:fitsSystemWindows="true"
        //true 给系统view预留空间  false 是app占据全部空间
//        else {
//            StatusBarUtil.setFullScreen(this, false);
//            StatusBarUtil.showSystemUI(this);
//        }
        if (Config.isAutoSetTopBarColor) {
            if (Config.topBarColor != 0) {
                setTopStatus(Config.topBarColor, null);
            } else {
                setTopStatus(R.color.colorPrimary, null);
            }
        }

    }

    /**
     * 标题栏与手机顶部状态栏颜色保持一致
     *
     * @param colorRes 颜色
     */
    protected void setTopStatus(@Nullable int colorRes, View appBar) {
        StatusBarUtil.setWindowStatusBarColorWithActivity(this, colorRes);
        if (appBar != null) {
            appBar.setBackgroundResource(colorRes);
        }
    }


    public void showToastShort(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(baseContext, txt, Toast.LENGTH_SHORT).show();
            }
        });
    }

    public void showToastLong(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(baseContext, txt, Toast.LENGTH_LONG).show();
            }
        });
    }

    public void showSuccessShort(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                TopSnackBarUtil.showSuccessShort(BaseActivity.this, txt);
            }
        });
    }

    public void showWarnLong(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                TopSnackBarUtil.showWarnLong(BaseActivity.this, txt);
            }
        });
    }

    public void showWarnShort(final String txt) {
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                TopSnackBarUtil.showWarnShort(BaseActivity.this, txt);
            }
        });
    }

    /**
     * 错误级提示 （top） 短的
     */
    public void showErrorShort(final String txt) {
        if (Config.isShowError) {
            BaseApp.getMainHandler().post(new Runnable() {
                @Override
                public void run() {
                    TopSnackBarUtil.showErrorShort(BaseActivity.this, txt);
                }
            });
        }
    }

    /**
     * 错误级提示 （top） 长的
     */
    public void showErrorLong(final String txt) {
        if (Config.isShowError) {
            BaseApp.getMainHandler().post(new Runnable() {
                @Override
                public void run() {
                    TopSnackBarUtil.showErrorLong(BaseActivity.this, txt);
                }
            });
        }
    }


    @Override
    public void finish() {
        super.finish();
        //overridePendingTransition(R.anim.utils_fade_in, R.anim.utils_fade_out);
    }


    @SuppressLint("StaticFieldLeak")
    protected static SweetAlertDialog sweetAlertDialog;

    /**
     * 警示对话框
     */
    public void showSweetWarnDialog(final String title, final SweetAlertDialog.OnSweetClickListener confirmListener) {
        dismissSweetDialog();
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                sweetAlertDialog = SweetDialogUtil.getWarningDialog(baseContext);
                sweetAlertDialog.setTitleText(title)
                        .setContentText(null)
                        .setCancelText(getString(R.string.resource_public_cancel))
                        .setCancelClickListener(null)
                        .setConfirmText(getString(R.string.resource_public_confirm))
                        .setConfirmClickListener(confirmListener)
                        .show();
            }
        });
    }

    /**
     * 等待的提示
     */
    public void showSweetProgressDialog(final String title) {
        dismissSweetDialog();
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                sweetAlertDialog = SweetDialogUtil.getProgressDialog(baseContext);
                sweetAlertDialog.setTitleText(title).setContentText(null).show();
            }
        });
    }

    /**
     * 失败的提示
     */
    public void showSweetErrorDialog(final String content) {
        dismissSweetDialog();
        if (Config.isShowError) {
            BaseApp.getMainHandler().post(new Runnable() {
                @Override
                public void run() {
                    sweetAlertDialog = SweetDialogUtil.getErrorDialog(baseContext);
                    sweetAlertDialog.setTitleText(null)
                            .setContentText(content)
                            .setConfirmText(getString(R.string.resource_public_know))
                            .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                                @Override
                                public void onClick(SweetAlertDialog sweetAlertDialog) {
                                    sweetAlertDialog.dismissWithAnimation();
                                }
                            }).show();
                }
            });
        }
    }

    /**
     * 成功的提示
     */
    public void showSweetSuccessDialog(final String title) {
        dismissSweetDialog();
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                sweetAlertDialog = SweetDialogUtil.getSuccessDialog(baseContext);
                sweetAlertDialog.setTitleText(title)
                        .setConfirmText(getString(R.string.resource_public_ok))
                        .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                            @Override
                            public void onClick(SweetAlertDialog sweetAlertDialog) {
                                sweetAlertDialog.dismissWithAnimation();
                            }
                        }).show();
            }
        });
    }

    /**
     * 成功的提示  并在1秒后关闭
     */
    public void showSweetSuccessDialogAndDelayClose(final String title) {
        dismissSweetDialog();
        BaseApp.getMainHandler().post(new Runnable() {
            @Override
            public void run() {
                sweetAlertDialog = SweetDialogUtil.getSuccessDialog(baseContext);
                sweetAlertDialog.setTitleText(title)
                        .setConfirmText(getString(R.string.resource_public_ok))
                        .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                            @Override
                            public void onClick(SweetAlertDialog sweetAlertDialog) {
                                sweetAlertDialog.dismissWithAnimation();
                            }
                        }).show();
            }
        });

        BaseApp.getMainHandler().postDelayed(new Runnable() {
            @Override
            public void run() {
                dismissSweetDialog();
            }
        }, 1000);
    }


    /**
     * 关闭提示对话框
     */
    public void dismissSweetDialog() {
        if (sweetAlertDialog != null) {
            BaseApp.getMainHandler().post(new Runnable() {
                @Override
                public void run() {
                    if (sweetAlertDialog != null) {
                        sweetAlertDialog.dismissWithAnimation();
                        sweetAlertDialog = null;
                    }
                }
            });
        }
    }


    //当屏幕发生旋转
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        switch (newConfig.orientation) {
            //更改为LANDSCAPE
            case (Configuration.ORIENTATION_LANDSCAPE):
                break;
            //更改为PORTRAIT
            case (Configuration.ORIENTATION_PORTRAIT):
                break;
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (KeyEvent.KEYCODE_DEL == event.getKeyCode()) {
            //软键盘的删除键
            return false;
        } else if (KeyEvent.KEYCODE_VOLUME_DOWN == event.getKeyCode() || KeyEvent.KEYCODE_VOLUME_UP == event.getKeyCode()) {
            //音量上、下键
            return false;
        }
        if (Config.isBackToHome) {
            IntentUtil.goHome(this);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}
