package com.ruiwenliu.wrapper.util;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseViewHolder;
import com.frame.base.glide.GlideManager;

/**
 * Created :Auser
 * Date: 2019/5/16.
 * Desc:图片加载基类
 */

public class BaseGlideHolder extends BaseViewHolder {
    public BaseGlideHolder(View view) {
        super(view);
    }

    /**
     * 加载普通图片
     *
     * @param url
     * @param image
     */
    public void loadImage(Context context, String url, ImageView image) {

        GlideManager.getInstance(context).loadImage(url, image);
    }


    /**
     * 加载圆角图片
     *
     * @param url
     * @param image
     * @param round
     */
    public void loadRoundImage(Context context, String url, ImageView image, int round) {

        loadImage(context, url, image);
    }


}
