package com.rv.travel.other;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.View;

import com.base.utils.base.BaseActivity;
import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.frame.rv.BaseTitleBarLayout;
import com.rv.travel.R;
import com.rv.travel.R2;

import butterknife.BindView;
import butterknife.ButterKnife;
//所有的子页面的依附的Activity
public class TravelFragmentActivity extends BaseActivity {
    public static OtherOption option = null;
    public static Fragment currentFragment = null;
    @SuppressLint("StaticFieldLeak")
    public static TravelFragmentActivity instance = null;

    public static TravelFragmentActivity getInstance() {
        return TravelFragmentActivity.instance;
    }

    @BindView(R2.id.other_title_bar_layout)
    BaseTitleBarLayout titleBarLayout;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_fragment_other);
        ButterKnife.bind(this);
        TravelFragmentActivity.instance = this;
        onData();
        onView();
    }


    @Override
    public void onData() {
        applyOption();
    }

    @Override
    public void onView() {
        setCurrentFragment();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        applyOption();
        setCurrentFragment();
    }

    //加载碎片
    private void setCurrentFragment() {
        if (TravelFragmentActivity.currentFragment != null) {
            getSupportFragmentManager().beginTransaction().replace(R.id.other_fragment_layout, TravelFragmentActivity.currentFragment).commitAllowingStateLoss();
        }
    }

    //设置参数
    private void applyOption() {
        if (TravelFragmentActivity.option == null) return;
        titleBarLayout.setTitleText(TravelFragmentActivity.option.getTitle());
        if (TravelFragmentActivity.option.getClickListener() == null) {
            titleBarLayout.setBackClickListener(null);
        } else {
            titleBarLayout.setBackClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    TravelFragmentActivity.option.getClickListener().onBack();
                }
            });
            if (!TextUtil.isEmpty(TravelFragmentActivity.option.getButtonText())) {
                titleBarLayout.setButtonView(option.getButtonText(), new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        TravelFragmentActivity.option.getClickListener().onButton();
                    }
                });
            }
        }

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        TravelFragmentActivity.currentFragment = null;
        TravelFragmentActivity.instance = null;
        TravelFragmentActivity.option = null;
    }
}
