package com.rv.travel.fragment;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import com.base.utils.base.BaseFragment;
import com.base.utils.tools.android.IntentUtil;
import com.just.agentweb.AgentWeb;
import com.rv.travel.GoOtherUtil;
import com.rv.travel.R;
import com.rv.travel.R2;
import com.rv.travel.other.OtherClickListener;
import com.rv.travel.other.OtherOption;
import com.rv.travel.other.TravelFragmentActivity;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.Unbinder;
//旅游详情
public class TravelWebFragment extends BaseFragment {

    public static TravelWebFragment getInstance(String url) {
        TravelWebFragment instance = new TravelWebFragment();
        instance.URL_ADDRESS = url;
        return instance;
    }

    private String URL_ADDRESS = "";
    @BindView(R2.id.travel_web_fragment_root)
    FrameLayout rootLayout;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_web, container, false);
        unbinder = ButterKnife.bind(this, view);
        view.findViewById(R.id.travel_web_go_order).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
               GoOtherUtil.goTravelCommitOrder(getActivity());
            }
        });
        return view;
    }

    Unbinder unbinder;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        onData();
        onView();
    }


    @Override
    public void onData() {



    }

    @Override
    public void onView() {
        goWeb();

    }


    @Override
    public void onDestroyView() {
        super.onDestroyView();

    }

    AgentWeb mAgentWeb;

    private void goWeb() {
        mAgentWeb = AgentWeb.with(this)
                .setAgentWebParent(rootLayout, new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT))
                .useDefaultIndicator()
                .createAgentWeb()
                .ready()
                .go(URL_ADDRESS);
    }

    /**
     * 准备确认订单
     * @param company  公司名
     * @param address  公司地址
     * @param aim      目的地
     * @param startDate  开始日期
     * @param endDate    结束日期
     * @param startWeek  开始的星期
     * @param endWeek    结束的星期
     * */
    public void readyOrder(String company,
                           String address,
                           String aim,
                           String startDate,
                           String endDate,
                           String startWeek,
                           String endWeek){

        GoOtherUtil.goTravelCommitOrder(getActivity());

    }

    public void readyOrder(String orderJson){

    }
}
