package com.rv.travel.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.base.utils.base.BaseFragment;
import com.base.utils.tools.android.IntentUtil;
import com.frame.base.browse.ActivityImageBrowseInt;
import com.frame.base.glide.GlideManager;
import com.rv.travel.GoOtherUtil;
import com.rv.travel.R;
import com.rv.travel.R2;
import com.rv.travel.TravelActivity;
import com.rv.travel.adapter.AdapterRim;
import com.rv.travel.bean.BeanRim;
import com.rv.travel.other.OtherClickListener;
import com.rv.travel.other.OtherOption;
import com.rv.travel.other.TravelFragmentActivity;
import com.yuyife.banner.Banner;
import com.yuyife.banner.BannerConfig;
import com.yuyife.banner.listener.OnBannerListener;
import com.yuyife.banner.loader.ImageLoader;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.Unbinder;
//热门旅游 某个子栏目
public class TravelFragmentHotType extends BaseFragment {
    @BindView(R2.id.travel_banner)
    Banner banner;

    @BindView(R2.id.travel_rim_recycler)
    RecyclerView rimRecycler;

    @BindView(R2.id.travel_fragment_hot_more_layout)
    FrameLayout hotMoreLayout;

    @SuppressLint("StaticFieldLeak")
    public static FrameLayout hotMoreLayoutStatic;

//    @OnClick({R2.id.travel_hot_more_image
//    })
//    public void onTravelFragmentHotTypeClick(View view) {
//        int id = view.getId();
//        if (id == R.id.travel_hot_more_image) {
//            NiftyEffects.jelly.getAnimator().in(view);
//
//        }
//    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_travel_hot_type, container, false);
        unbinder = ButterKnife.bind(this, view);
        return view;
    }

    Unbinder unbinder;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        hotMoreLayoutStatic = hotMoreLayout;
        onData();
        onView();
    }


    @Override
    public void onData() {

        setRim();
    }

    @Override
    public void onView() {

        setBanner();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        hotMoreLayoutStatic = null;
    }

    private AdapterRim adapterRim;

    private void setRim() {

        List<BeanRim> data = new ArrayList<>();
        data.add(new BeanRim());
        data.add(new BeanRim());
        data.add(new BeanRim());
        data.add(new BeanRim());
        data.add(new BeanRim());
        data.add(new BeanRim());
        data.add(new BeanRim());
        data.add(new BeanRim());
        data.add(new BeanRim());
        adapterRim = new AdapterRim(R.layout.item_travel_rim, data);
        adapterRim.setItemRootClickListener(new AdapterRim.OnItemRootClickListener() {
            @Override
            public void onItemClick(BeanRim bean) {
                GoOtherUtil.goTravelDetailWeb(getActivity());
            }
        });
        final LinearLayoutManager linearLayoutManager = new LinearLayoutManager(baseContext);
        linearLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        rimRecycler.setLayoutManager(linearLayoutManager);

        rimRecycler.setAdapter(adapterRim);

    }


    private ArrayList<String> images = new ArrayList<>();    //图片(默认采用网络地址)
    private List<String> titles = new ArrayList<>();         //图片标题
    private List<Integer> localImages = new ArrayList<>();   //图片(本地资源)

    private void setBanner() {
        titles.clear();
        images.clear();
        localImages.clear();

        localImages.add(R.mipmap.banner_test3);
        localImages.add(R.mipmap.banner_test4);

        banner.setImages(localImages);
        for (int i = 0; i < localImages.size(); i++) {
            titles.add("");
        }
        banner.isAutoPlay(true)
                .setBannerTitles(titles)
                .setDelayTime(3000)
                .setImageLoader(new ImageLoader() {
                    @Override
                    public void displayImage(Context context, Object path, ImageView imageView) {

                        GlideManager.getInstance(context).loadImage(path, imageView);
                    }
                })
                .setOnBannerListener(new OnBannerListener() {
                    @Override
                    public void OnBannerClick(int position) {
                        if (localImages != null && localImages.size() > 0) {
                            Bundle bundle = new Bundle();
                            bundle.putInt(ActivityImageBrowseInt.KEY_BACKGROUND, R.color.colorPrimary);
                            bundle.putIntegerArrayList(ActivityImageBrowseInt.KEY_IMAGE, (ArrayList<Integer>) localImages);
                            IntentUtil.startActivity(baseContext, ActivityImageBrowseInt.class, bundle);
                        }
                    }
                })
                .start();

        banner.updateBannerStyle(BannerConfig.CIRCLE_INDICATOR);
    }

    private TravelFragmentHotMore travelFragmentHotMore;

    public void setHotMoreFragment() {
        TravelActivity.hotMoreTitleLayoutStatic.setVisibility(View.VISIBLE);
        hotMoreLayoutStatic.setVisibility(View.VISIBLE);

        if (travelFragmentHotMore == null) {
            travelFragmentHotMore = TravelFragmentHotMore.getInstance(TravelFragmentHotType.class.getSimpleName());
        }
        getChildFragmentManager().beginTransaction().replace(R.id.travel_fragment_hot_more_layout, travelFragmentHotMore).commitAllowingStateLoss();

    }

    public static void hideHotMoreFragment() {
        TravelActivity.hotMoreTitleLayoutStatic.setVisibility(View.GONE);
        hotMoreLayoutStatic.setVisibility(View.GONE);

    }
}
