package com.rv.travel.fragment;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.base.animset.util.NiftyEffects;
import com.base.utils.base.BaseFragment;
import com.rv.travel.adapter.AdapterHot;
import com.rv.travel.R;
import com.rv.travel.R2;
import com.rv.travel.TravelActivity;
import com.rv.travel.bean.BeanHot;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import butterknife.Unbinder;
//热门旅游  更多
public class TravelFragmentHotMore extends BaseFragment {
    private String clientClazzName = null;

    public static TravelFragmentHotMore getInstance(String clientClazzName) {
        TravelFragmentHotMore instance = new TravelFragmentHotMore();
        instance.clientClazzName = clientClazzName;
        return instance;
    }

    @BindView(R2.id.travel_hot_more_recycler)
    RecyclerView hotRecycler;

    @OnClick({R2.id.travel_hot_more_close
    })
    public void onTravelFragmentHotMoreClick(View view) {
        int id = view.getId();
        if (id == R.id.travel_hot_more_close) {
            NiftyEffects.jelly.getAnimator().in(view);
            //关闭
            if (clientClazzName==null){

            }else if(clientClazzName.equals(TravelFragmentMain.class.getSimpleName())) {
                TravelFragmentMain.hideHotMoreFragment();
            }else if(clientClazzName.equals(TravelFragmentHotType.class.getSimpleName())) {
                TravelFragmentHotType.hideHotMoreFragment();
            }
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_travel_hot_more, container, false);
        unbinder = ButterKnife.bind(this, view);
        return view;
    }

    Unbinder unbinder;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        onData();
        onView();
    }


    @Override
    public void onData() {

        setHot();


    }

    @Override
    public void onView() {

    }

    private AdapterHot adapterHot;

    private void setHot() {
        List<BeanHot> data = new ArrayList<>();
        data.add(new BeanHot());
        data.add(new BeanHot());
        data.add(new BeanHot());
        data.add(new BeanHot());
        data.add(new BeanHot());
        data.add(new BeanHot());
        data.add(new BeanHot());
        data.add(new BeanHot());
        data.add(new BeanHot());
        adapterHot = new AdapterHot(R.layout.item_travel_hot_more, data);
        adapterHot.setOnItemRootClickListener(new AdapterHot.OnItemRootClickListener() {
            @Override
            public void onItemClick(BeanHot bean) {
                TravelActivity.getInstance().setTravelFragmentHotType();
            }
        });
        GridLayoutManager gridLayoutManager = new GridLayoutManager(baseContext, 3);
        hotRecycler.setLayoutManager(gridLayoutManager);

        hotRecycler.setAdapter(adapterHot);
    }


}
