package com.rv.travel.fragment;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;

import com.base.utils.base.BaseFragment;
import com.rv.travel.R;
import com.rv.travel.R2;
import com.rv.travel.adapter.AdapterTravelMember;
import com.rv.travel.bean.BeanTravelMember;
import com.rv.travel.dialog.TravelDialogUtil;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import butterknife.Unbinder;

//确认下单
public class TravelFragmentCommitOrder extends BaseFragment {

    public static TravelFragmentCommitOrder getInstance() {
        TravelFragmentCommitOrder instance = new TravelFragmentCommitOrder();
        return instance;
    }

    @BindView(R2.id.commit_order_check_box)
    CheckBox commitCheck;
    @BindView(R2.id.commit_order_member_recycler)
    RecyclerView memberRecycler;

    @OnClick({
            R2.id.commit_order_agree,
            R2.id.commit_order_button,
            R2.id.commit_order_select_member_text,
            R2.id.commit_order_select_member_icon,
            R2.id.commit_order_money_detail,
    })
    public void onTravelFragmentCommitOrderClick(View view) {
        int id = view.getId();
        if (id == R.id.commit_order_agree) {
            //合同协议
        } else if (id == R.id.commit_order_button) {
            //提交订单
            TravelDialogUtil.showPaySelectDialog(baseContext, new TravelDialogUtil.OnDialogDoneCallback<Boolean>() {
                @Override
                public void done(Boolean aBoolean) {

                }
            });
        }  else if (id == R.id.commit_order_money_detail) {
            //费用明细
            TravelDialogUtil.showCommitOrderMoneyDetail(baseContext);
        } else if (id == R.id.commit_order_select_member_text || id == R.id.commit_order_select_member_icon) {
            //选人员
            List<BeanTravelMember> data = new ArrayList<>();
            data.add(new BeanTravelMember("张3", "0"));
            data.add(new BeanTravelMember("张4", "1"));
            data.add(new BeanTravelMember("张5", "2"));

            TravelDialogUtil.showSelectTravel(baseContext, data, new TravelDialogUtil.OnDialogDoneCallback<BeanTravelMember>() {
                @Override
                public void done(BeanTravelMember beanTravelMember) {
                    if (selectData.contains(beanTravelMember)) {
                        return;
                    }
                    selectData.add(beanTravelMember);
                    adapterTravelMember.setNewData(selectData);
                }
            });
        }
    }


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_travel_commit_order, container, false);
        unbinder = ButterKnife.bind(this, view);
        return view;
    }

    Unbinder unbinder;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        onData();
        onView();
    }

    private AdapterTravelMember adapterTravelMember;
    private List<BeanTravelMember> selectData = new ArrayList<>();

    @Override
    public void onData() {
        adapterTravelMember = new AdapterTravelMember(R.layout.item_travel_member, selectData);
        adapterTravelMember.setItemRootClickListener(new AdapterTravelMember.OnItemAllClickListener() {
            @Override
            public void onItemRootClick(final BeanTravelMember bean) {

            }

            @Override
            public void onItemDeleteClick(BeanTravelMember bean) {

                selectData.remove(bean);
                adapterTravelMember.setNewData(selectData);
            }
        });
        memberRecycler.setLayoutManager(new LinearLayoutManager(baseContext));
        memberRecycler.setAdapter(adapterTravelMember);

    }

    @Override
    public void onView() {

    }

}