package com.rv.travel.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;

import com.base.utils.ui.dialog.DialogPlusUtil;
import com.base.utils.ui.dialog.DialogUtil;
import com.frame.base.FrameApp;
import com.orhanobut.dialogplus.DialogPlus;
import com.rv.travel.R;
import com.rv.travel.bean.BeanTravelMember;

import java.util.List;

public class TravelDialogUtil {
    public interface OnDialogDoneCallback<T> {
        void done(T t);
    }


    //选择出游人
    public static void showSelectTravel(Context context, final List<BeanTravelMember> data,
                                        final OnDialogDoneCallback<BeanTravelMember> callback) {
        final String[] items;

        if (data == null || data.size() == 0) {
            items = new String[]{"无"};
        } else {
            items = new String[data.size()];
            int i = 0;
            for (BeanTravelMember bean : data) {
                String text = bean.getName();
                items[i] = text;
                i += 1;
            }
        }
        DialogUtil.getItemDialog(context, items, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (callback != null) {
                    if (data != null && data.size() > 0) {
                        callback.done(data.get(which));
                    }
                }

            }
        }).setTitle("选择出游人").create().show();
    }

    public static void showCommitOrderMoneyDetail(final Context context) {
        View dialogView = LayoutInflater.from(context).inflate(R.layout.dialog_order_money_detail, null);
        TravelDialogUtil.mDialogPlus = DialogPlusUtil.getDialogPlus(context, dialogView)
                .create();
        TravelDialogUtil.mDialogPlus.show();
        dialogView.findViewById(R.id.money_detail_close).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismissDialogPlus();
            }
        });

        dialogView.findViewById(R.id.commit_order_button).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismissDialogPlus();
                FrameApp.getMainHandler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        showPaySelectDialog(context, new OnDialogDoneCallback<Boolean>() {
                            @Override
                            public void done(Boolean aBoolean) {

                            }
                        });
                    }
                }, 600);
            }
        });
    }


    @SuppressLint("StaticFieldLeak")
    public static DialogPlus mDialogPlus = null;

    public static void dismissDialogPlus() {
        if (mDialogPlus != null) {
            mDialogPlus.dismiss();
            mDialogPlus = null;
        }
    }

    private static boolean isPayWx = true;//默认选择微信支付


    //选择支付
    public static void showPaySelectDialog(Context context, final OnDialogDoneCallback<Boolean> listener) {
        isPayWx = true;
        dismissDialogPlus();
        View dialogView = LayoutInflater.from(context).inflate(R.layout.dialog_order_select_pay, null);
        TravelDialogUtil.mDialogPlus = DialogPlusUtil.getDialogPlus(context, dialogView)
                .create();
        TravelDialogUtil.mDialogPlus.show();
        final ImageView payWx = dialogView.findViewById(R.id.select_pay_wx);
        final ImageView payZfb = dialogView.findViewById(R.id.select_pay_zfb);
        payWx.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                isPayWx = true;
                payWx.setImageResource(R.mipmap.common_icon_pay_round);
                payZfb.setImageResource(R.mipmap.common_icon_round);
            }
        });
        payZfb.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                isPayWx = false;
                payZfb.setImageResource(R.mipmap.common_icon_pay_round);
                payWx.setImageResource(R.mipmap.common_icon_round);
            }
        });
        dialogView.findViewById(R.id.select_pay_close).
                setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismissDialogPlus();
                    }
                });
        dialogView.findViewById(R.id.inquiry_doctor_pay_submit).
                setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismissDialogPlus();

                        if (listener != null) {
                            listener.done(isPayWx);
                        }
                    }
                });
    }


}
