package com.rv.travel.adapter;

import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.view.View;

import com.base.utils.tools.android.IntentUtil;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.travel.R;
import com.rv.travel.bean.BeanRim;

import java.util.List;

public class AdapterRim extends BaseQuickAdapter<BeanRim, AdapterRim.AdapterViewHolder> {
    public interface OnItemRootClickListener {
        void onItemClick(BeanRim bean);
    }

    private OnItemRootClickListener itemClickListener;

    public void setItemRootClickListener(OnItemRootClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public AdapterRim(int layoutResId, @Nullable List<BeanRim> data) {
        super(layoutResId, data);
    }

    @Override
    protected void convert(AdapterViewHolder helper, BeanRim item) {
        helper.itemRoot.setTag(item);

        helper.itemRoot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (itemClickListener != null) {
                    BeanRim beanRim = (BeanRim) v.getTag();
                    itemClickListener.onItemClick(beanRim);
                }
            }
        });
    }

    public class AdapterViewHolder extends BaseViewHolder {


        CardView itemRoot;

        public AdapterViewHolder(View view) {
            super(view);
            itemRoot = view.findViewById(R.id.item_rim_root);
        }
    }
}
