package com.rv.travel;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.base.utils.base.BaseActivity;
import com.frame.rv.BaseTabLayout;
import com.frame.rv.ModuleChangeUtil;
import com.frame.rv.OnModuleChangedListener;
import com.rv.travel.fragment.TravelFragmentHotType;
import com.rv.travel.fragment.TravelFragmentMain;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

public class TravelActivity extends BaseActivity {
    @SuppressLint("StaticFieldLeak")
    private static TravelActivity instance;

    public static TravelActivity getInstance() {
        return instance;
    }

    @BindView(R2.id.travel_tab_layout)
    BaseTabLayout tabLayout;
    @BindView(R2.id.travel_city_layout)
    LinearLayout cityLayout;
    @BindView(R2.id.travel_city_text)
    TextView cityText;
    @BindView(R2.id.search_input)
    EditText searchInput;
    @BindView(R2.id.search_commit)
    TextView searchCommit;
    @BindView(R2.id.travel_server_image)
    ImageView serverImage;
    @BindView(R2.id.travel_hot_more_layout)
    LinearLayout hotMoreTitleLayout;
    @BindView(R2.id.travel_hot_type_layout)
    FrameLayout hotTypeTitleLayout;


    @OnClick({
            R2.id.travel_hot_type_back,
            R2.id.travel_hot_type_select,
            R2.id.search_commit,
            R2.id.travel_server_image,
    })
    public void onTravelActivityClick(View view) {
        int id = view.getId();
        if (id == R.id.travel_hot_type_back) {
            setTravelFragmentMain();
        } else if (id == R.id.travel_hot_type_select) {
            travelFragmentHotType.setHotMoreFragment();
        } else if (id == R.id.search_commit) {
            searchInput.setText("");
        } else if (id == R.id.travel_server_image) {
            showToastShort("联系客服");
        }
    }

    @SuppressLint("StaticFieldLeak")
    public static LinearLayout hotMoreTitleLayoutStatic;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_travel);
        ButterKnife.bind(this);
        instance = this;
        ModuleChangeUtil.currentActivity = this;
        hotMoreTitleLayoutStatic = hotMoreTitleLayout;
        onData();
        onView();
    }

    @Override
    public void onData() {
        tabLayout.setCurrent(OnModuleChangedListener.MODULE_TRAVEL);
    }

    @Override
    public void onView() {
        setTravelFragmentMain();

        searchInput.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                if (s != null && s.length() > 0) {
                    searchCommit.setVisibility(View.VISIBLE);
                } else {
                    searchCommit.setVisibility(View.GONE);
                }
            }
        });
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        ModuleChangeUtil.currentActivity = this;

    }

    private TravelFragmentMain travelFragmentMain;

    //主页面，点击 热门游 更多 弹出列表  
    public void setTravelFragmentMain() {
        hotMoreTitleLayout.setVisibility(View.GONE);
        hotTypeTitleLayout.setVisibility(View.GONE);
        if (travelFragmentMain == null) {
            travelFragmentMain = new TravelFragmentMain();
        }
        setFragment(travelFragmentMain);
    }

    private TravelFragmentHotType travelFragmentHotType;

    //点击 热门游 弹出列表  点击列表条目，设置
    public void setTravelFragmentHotType() {
        hotMoreTitleLayout.setVisibility(View.GONE);
        hotTypeTitleLayout.setVisibility(View.VISIBLE);
        travelFragmentHotType = new TravelFragmentHotType();
        setFragment(travelFragmentHotType);
    }

    private void setFragment(Fragment fragment) {

        getSupportFragmentManager().beginTransaction().replace(R.id.travel_fragment_layout, fragment).commitAllowingStateLoss();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        instance = null;
        hotMoreTitleLayoutStatic = null;
        if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
            ModuleChangeUtil.getOnModuleChangedListener().onClear();
        }
    }
}
