package com.rv.rvmine;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.base.utils.base.BaseActivity;
import com.base.utils.ui.image.round.RoundImageView;
import com.frame.base.glide.GlideManager;
import com.frame.rv.BaseTabLayout;
import com.frame.rv.ModuleChangeUtil;
import com.frame.rv.OnModuleChangedListener;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.login.LoginRvActivity;
import com.rv.home.rv.module.ui.main.home.order.OrderListActivity;
import com.yuyife.okgo.OkGoUtil;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

public class MineActivity extends BaseStatusActivity<CommonPresenter> {

    @BindView(R2.id.travel_tab_layout)
    BaseTabLayout travelTabLayout;
    @BindView(R2.id.iv_avatar)
    RoundImageView ivAvatar;
    @BindView(R2.id.tv_nickname)
    TextView tvNickname;
    @BindView(R2.id.iv_member)
    ImageView ivMember;
    @BindView(R2.id.tv_login)
    TextView tvLogin;
    @BindView(R2.id.tv_verified)
    TextView tvVerified;
    @BindView(R2.id.iv_notification)
    ImageView ivNotification;
    @BindView(R2.id.tv_membership_level)
    TextView tvMembershipLevel;
    @BindView(R2.id.tv_member_hint)
    TextView tvMemberHint;
    @BindView(R2.id.tv_view_privileges)
    TextView tvViewPrivileges;
    @BindView(R2.id.rl_item_to_be_paid)
    RelativeLayout rlItemToBePaid;
    @BindView(R2.id.rl_item_staying)
    RelativeLayout rlItemStaying;
    @BindView(R2.id.rl_item_traveling)
    RelativeLayout rlItemTraveling;
    @BindView(R2.id.rl_item_completed)
    RelativeLayout rlItemCompleted;
    @BindView(R2.id.rl_item_all)
    RelativeLayout rlItemAll;
    @BindView(R2.id.rl_item_collection)
    RelativeLayout rlItemCollection;
    @BindView(R2.id.rl_item_personal_information)
    RelativeLayout rlItemPersonalInformation;
    @BindView(R2.id.rl_item_information)
    RelativeLayout rlItemInformation;
    @BindView(R2.id.rl_item_setting)
    RelativeLayout rlItemSetting;
    @BindView(R2.id.travel_fragment_layout)
    LinearLayout travelFragmentLayout;

    @Override
    protected int setLayout() {
        return R.layout.activity_mine;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        ModuleChangeUtil.currentActivity = this;

        showTitle(false);
        travelTabLayout.setCurrent(OnModuleChangedListener.MODULE_MINE);

        if (TextUtils.isEmpty( OkGoUtil.getToken())) {
            tvNickname.setVisibility(View.GONE);
            ivMember.setVisibility(View.GONE);
            tvLogin.setVisibility(View.VISIBLE);
            tvVerified.setVisibility(View.GONE);
        }else {
            tvNickname.setVisibility(View.VISIBLE);
            ivMember.setVisibility(View.VISIBLE);
            tvLogin.setVisibility(View.GONE);
            tvVerified.setVisibility(View.VISIBLE);
            Log.i("Mineactivityty", "initView: " +UtilsManager.getInstance(mActivity).getSPStringCode("city_json","headerurl"));
            GlideManager.getInstance(mActivity).loadImage(UtilsManager.getInstance(mActivity).getSPStringCode("city_json","headerurl"), ivAvatar);
            tvNickname.setText(UtilsManager.getInstance(mActivity).getSPStringCode("city_json","username"));
        }
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        ModuleChangeUtil.currentActivity = this;

    }

    @OnClick({R2.id.iv_avatar, R2.id.tv_login, R2.id.tv_verified, R2.id.rl_item_to_be_paid, R2.id.rl_item_staying, R2.id.rl_item_traveling, R2.id.rl_item_completed, R2.id.rl_item_all, R2.id.rl_item_collection, R2.id.rl_item_personal_information, R2.id.rl_item_information, R2.id.rl_item_setting})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id ==R.id.iv_avatar){
            //头像
            if (isLogin()) return;
        }else if (id== R.id.tv_login){
           //登录
            startActivity(LoginRvActivity.getIntent(mActivity));
        }else if (id == R.id.tv_verified){
           //实名认证
            if (isLogin()) return;
            startActivity(IDCardCertificationActivity.getIntent(mActivity));
        }else if (id == R.id.rl_item_to_be_paid){
            //待支付
            if (isLogin()) return;
            startActivity(OrderListActivity.getIntent(mActivity, 0));
        }else if (id == R.id.rl_item_staying){
            //待出行
            if (isLogin()) return;
            startActivity(OrderListActivity.getIntent(mActivity, 1));
        }else if (id ==R.id.rl_item_traveling){
            //出行中
            if (isLogin()) return;
            startActivity(OrderListActivity.getIntent(mActivity, 2));
        }else if (id == R.id.rl_item_completed){
            //已完成
            if (isLogin()) return;
            startActivity(OrderListActivity.getIntent(mActivity, 3));
        }else if (id ==R.id.rl_item_all){
            //全部
            if (isLogin()) return;
            startActivity(OrderListActivity.getIntent(mActivity, 4));
        }else if (id == R.id.rl_item_collection){
           //收藏
            if (isLogin()) return;
            showToast("该功能还在开发中");
        }else if (id == R.id.rl_item_personal_information){
            //个人资料
            if (isLogin()) return;
            showToast("该功能还在开发中");
        }else if (id == R.id.rl_item_information){
            //信息
            if (isLogin()) return;
            showToast("该功能还在开发中");
        }else if (id ==R.id.rl_item_setting){
           //设置
        }
    }

    /**
     * 判断是否登录
     * @return
     */
    private boolean isLogin() {
        if (TextUtils.isEmpty( OkGoUtil.getToken())) {
            startActivity(LoginRvActivity.getIntent(mActivity));
            return true;
        }
        return false;
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
            ModuleChangeUtil.getOnModuleChangedListener().onClear();
        }
    }
}
