package com.rv.home.wxapi;


import android.content.Intent;
import android.os.Bundle;
import android.widget.TextView;

import com.frame.rv.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.order.OrderListActivity;
import com.rv.home.rv.until.bus.PayEvent;
import com.rv.home.rv.until.bus.RxBus;
import com.tencent.mm.opensdk.constants.ConstantsAPI;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;

import butterknife.BindView;
import butterknife.OnClick;


public class WXPayEntryActivity extends BaseStatusActivity<CommonPresenter> implements IWXAPIEventHandler {

    private static final String TAG = "MicroMsg.SDKSample.WXPayEntryActivity";
    @BindView(R2.id.tv_content)
    TextView tvContent;
    @BindView(R2.id.tv_order)
    TextView tvOrder;

    private IWXAPI api;

    @Override
    protected int setLayout() {
        return R.layout.rv_pay_result;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(mActivity.getString(R.string.rv_weixin_pay_success));
        api = WXAPIFactory.createWXAPI(this, RvFrameConfig.APP_ID);
        api.handleIntent(getIntent(), this);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        setIntent(intent);
        api.handleIntent(intent, this);
    }

    @Override
    public void onReq(BaseReq req) {
    }

    @Override
    public void onResp(BaseResp resp) {
//		Log.d(TAG, "onPayFinish, errCode = " + resp.errCode);

        if (resp.getType() == ConstantsAPI.COMMAND_PAY_BY_WX) {
            switch (resp.errCode) {
                case 0:
                    RxBus.post(new PayEvent());
                    break;
                case -1:
                    finish();
                    break;
                case -2:
                    startActivity(OrderListActivity.getIntent(mActivity, 0));
                    RxBus.post(new PayEvent());
                    finish();
                    break;
            }
//            AlertDialog.Builder builder = new AlertDialog.Builder(this);
//            builder.setTitle("提示");
//            builder.setMessage("微信支付结果：" + String.valueOf(resp.errCode));
//            builder.show();
        }
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }


    @OnClick(R2.id.tv_order)
    public void onViewClicked() {
        startActivity(OrderListActivity.getIntent(mActivity, 1));
        finish();
    }
}