package com.rv.home.rv.module.ui.main.home.order.adapter;

import android.text.TextUtils;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.ruiwenliu.wrapper.util.TimeManager;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.rv.home.rv.module.ui.main.home.order.bean.ToTravelBean;

import java.util.List;

/**
 * Created :Auser
 * Date: 2019/5/31.
 * Desc:已出行
 */

public class HaveToTravelAdapter extends BaseMultiItemQuickAdapter<MultiItemEntity,BaseGlideHolder> {
    public static final int TYPE_FOR_PAYMENT=0;
    public static final int TYPE_TO_TRAVEL=1;

    public HaveToTravelAdapter(List<MultiItemEntity> data) {
        super(data);
        addItemType(TYPE_FOR_PAYMENT, R.layout.rv_item_order_for_payment);
        addItemType(TYPE_TO_TRAVEL, R.layout.rv_item_order_to_travel);
    }

    @Override
    protected void convert(BaseGlideHolder helper, MultiItemEntity item) {
        switch (helper.getItemViewType()){
            case TYPE_FOR_PAYMENT:
                OrderListBean.DataBeanX.DataBean dataBean= (OrderListBean.DataBeanX.DataBean) item;
                helper.setText(R.id.tv_order_time,String.format("%1$s%2$s",mContext.getString(R.string.rv_order_time),dataBean.getCrtTime()));
                helper.setText(R.id.tv_city,dataBean.getDetail().getStart_city_name());
                helper.setText(R.id.tv_order_state,mContext.getString(R.string.rv_order_have_travel));
                helper.loadRoundImage(mContext,dataBean.getPicture(), (ImageView) helper.getView(R.id.iv_goods),10);
                helper.setText(R.id.tv_car_type,dataBean.getName());
                helper.setText(R.id.tv_get_time, TimeManager.stampToDate(String.valueOf(dataBean.getDetail().getStart_time())));
                helper.setText(R.id.tv_get_address,dataBean.getDetail().getStart_addr());
                helper.setText(R.id.tv_out_time, TimeManager.stampToDate(String.valueOf(dataBean.getDetail().getEnd_time())));
                helper.setText(R.id.tv_out_address,dataBean.getDetail().getEnd_addr());
                helper.setText(R.id.tv_price,String.format("￥%1$s",dataBean.getOrderAmount()));
                helper.setText(R.id.tv_process,mContext.getString(R.string.rv_to_out_car));
                helper.addOnClickListener(R.id.tv_process);
                break;
            case TYPE_TO_TRAVEL:
                ToTravelBean toTravelBean= (ToTravelBean) item;
                helper.setText(R.id.tv_order_time,String.format("%1$s%2$s",mContext.getString(R.string.rv_order_time),"2019-8-12"));
                helper.setText(R.id.tv_city,"东莞市");
                helper.setText(R.id.tv_order_state,mContext.getString(R.string.rv_order_for_payment));
                String urls="https://gss1.bdstatic.com/-vo3dSag_xI4khGkpoWK1HF6hhy/baike/c0%3Dbaike180%2C5%2C5%2C180%2C60/sign=fc8e9183fd03738dca470470d272db34/10dfa9ec8a136327275f2c109a8fa0ec08fac767.jpg";
                helper.loadRoundImage(mContext,urls, (ImageView) helper.getView(R.id.iv_goods),50);
                helper.setText(R.id.tv_car_type,"奔驰最新款霸道房车");
                helper.setText(R.id.tv_out_time,String.format("%1$s%2$s",mContext.getString(R.string.rv_to_time),"2019-7-4"));
                helper.setText(R.id.tv_count_person,String.format("%1$s%2$s%2$s",mContext.getString(R.string.rv_to_time),"6",mContext.getString(R.string.rv_person)));
                helper.setText(R.id.tv_price,String.format("￥%1$s","3200000"));
                helper.setText(R.id.tv_camp_process,toTravelBean.name);
                helper.addOnClickListener(R.id.tv_camp_process);
                helper.setGone(R.id.tv_camp_process, TextUtils.isEmpty(toTravelBean.name)?false:true);
                break;
        }
    }

    public void addNewData(OrderListBean bean){
        mData.clear();
        addData(bean.getData().getData());
        notifyDataSetChanged();

    }
}
