package com.rv.home.rv.module.ui.main.home.order;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.PickerPresenter;
import com.rv.home.rv.module.ui.main.home.order.adapter.CancelTheTripAdapter;
import com.rv.home.rv.module.ui.main.home.order.bean.CancelTheTripBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * 取消行程
 */

public class CancelTheTripActivity extends BaseStatusActivity<PickerPresenter> {

    @BindView(R2.id.recyclerView)
    RecyclerView mRecyclerView;
    private CancelTheTripAdapter mAdapter;
    private String cancelReason;
    private String no;

    public static Intent getIntent(Context context, String no) {
        return new Intent(context, CancelTheTripActivity.class).putExtra("no", no);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                setResult(RESULT_OK);
                finish();
                break;
        }
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_cancel_the_trip;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(mActivity.getString(R.string.cancel_the_trip));

        no = intent.getStringExtra("no");

        mAdapter = new CancelTheTripAdapter();
        mRecyclerView.setLayoutManager(new LinearLayoutManager(mActivity));
        mRecyclerView.setAdapter(mAdapter);
        data();

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                List<CancelTheTripBean> data = adapter.getData();
                if (data != null) {
                    for (int i = 0; i < data.size(); i++) {
                        data.get(i).setCheck(false);
                    }
                }
                CancelTheTripBean item = (CancelTheTripBean) adapter.getItem(position);
                item.setCheck(true);
                cancelReason = item.getName();
                mAdapter.notifyDataSetChanged();
            }
        });
    }

    @OnClick(R2.id.tv_ok)
    public void onViewClicked() {
        if (TextUtils.isEmpty(cancelReason)) {
            showToast("请选择取消原因！");
            return;
        }
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
//        Map<String, Object> map = new LinkedHashMap<>();
//        map.put("cancelReason",cancelReason);
        mPresenter.postBodyData(RvFrameConfig.VEHICLE_ORDER, 0,
                ApiConfig.HTTP_URL_BASEORDER_CANCEL + no, CancelTheTripBean.class, new cancelReasonBean(cancelReason), headMap, true);
    }

    private class cancelReasonBean {
        private String cancelReason;

        public cancelReasonBean(String cancelReason) {
            this.cancelReason = cancelReason;
        }

        public String getCancelReason() {
            return cancelReason;
        }

        public void setCancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
        }
    }

    private void data() {
        ArrayList<CancelTheTripBean> list = new ArrayList<>();
        CancelTheTripBean bean = new CancelTheTripBean();
        bean.setName("行程有变，换其他出行方式");
        list.add(bean);
        CancelTheTripBean bean2 = new CancelTheTripBean();
        bean2.setName("租车费用太贵");
        list.add(bean2);
        CancelTheTripBean bean3 = new CancelTheTripBean();
        bean3.setName("驾照丢失");
        list.add(bean3);
        CancelTheTripBean bean4 = new CancelTheTripBean();
        bean4.setName("身体不适");
        list.add(bean4);
        CancelTheTripBean bean5 = new CancelTheTripBean();
        bean5.setName("其他原因");
        list.add(bean5);
        mAdapter.addData(list);
    }
}
