package com.rv.home.rv.module.ui.main.home;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.adapter.SelectShopAdapter;
import com.rv.home.rv.module.ui.main.home.bean.ShopListBean;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;

/**
 * Created :Auser
 * Date: 2019/5/18.
 * Desc:门店选择
 */
public class SelectShopActivity extends BaseStatusActivity<CommonPresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener  {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout mSimpleRefreshLayout;
    private SelectShopAdapter mAdapter;
    private int shopType;
    private String mCityId;
    private double mLat;
    private double mLon;
    private int mPage;
    private int countPage;


    public static Intent getIntent(Context context, int type, String id, double lat, double lon) {
        return new Intent(context, SelectShopActivity.class)
                .putExtra("type", type)
                .putExtra("city_id", id)
                .putExtra("lat", lat)
                .putExtra("lon", lon);
    }

    @Override
    protected int setLayout() {
        return R.layout.rv_act_shop_select;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(mActivity.getString(R.string.rv_select_shop));
        mCityId = intent.getStringExtra("city_id");
        mLat = intent.getIntExtra("lat", 0);
        mLon = intent.getIntExtra("lon", 0);
        mAdapter = new SelectShopAdapter();
        mAdapter.setOnLoadMoreListener(this, recyclerView);
        mSimpleRefreshLayout.setHeaderView(new SimpleRefreshView(this));
        mSimpleRefreshLayout.setOnSimpleRefreshListener(this);
        recyclerView.setLayoutManager(new LinearLayoutManager(mActivity));
        recyclerView.setAdapter(mAdapter);
        shopType = intent.getIntExtra("type", 1);

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                getIntent().putExtra("location", mAdapter.getItem(position).getName());
                getIntent().putExtra("type", shopType);
                setResult(RESULT_OK, getIntent());
                finish();
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        onRefresh();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

        processData((ShopListBean) result);
    }

    @Override
    public void onRefresh() {
        mPage = 1;
        getShopList(mPage);
    }

    @Override
    public void onLoadMoreRequested() {

        if(mPage>countPage){
            mAdapter.loadMoreEnd();

        }else {
            mPage++;
            getShopList(mPage);

        }


    }



    /**
     * 获取门店列表
     */
    private void getShopList(int page) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("page", page);
        map.put("limit", 10);
        map.put("addrCity", "441900");
        if(mLat>0){
            map.put("lat", mLat);
            map.put("lon", mLon);
        }
        mPresenter.getData(RvFrameConfig.VEHICLE_POST,0, ApiConfig.HTTP_URL_SHOP_LIST, ShopListBean.class,map, page == 1 ? true : false);
    }


    private void processData(ShopListBean bean){
        if(mPage==1){
            countPage=bean.getData().getTotalPage();
            mAdapter.setNewData(bean.getData().getData());
            mSimpleRefreshLayout.onRefreshComplete();
        }else {
            mAdapter.addData(bean.getData().getData());
            mAdapter.loadMoreComplete();
        }
    }



}
