package com.rv.home.rv.module.ui.main;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.frame.rv.ModuleChangeUtil;
import com.frame.rv.OnModuleChangedListener;
import com.ruiwenliu.wrapper.base.BaseActivity;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseWrapperFragment;
import com.ruiwenliu.wrapper.weight.CustomScrollViewPager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.login.LoginRvActivity;
import com.rv.home.rv.module.ui.main.adapter.TabAdapter;
import com.rv.home.rv.module.ui.main.camp.CampFragment;
import com.rv.home.rv.module.ui.main.found.FoundFragment;
import com.rv.home.rv.module.ui.main.home.HomePageFragment;
import com.rv.home.rv.module.ui.main.mine.MineFragment;
import com.rv.home.rv.module.ui.main.travel.TravelFragment;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

public class HomeActivity extends BaseActivity<CommonPresenter> {


    @BindView(R2.id.view_pager)
    CustomScrollViewPager viewPager;
    @BindView(R2.id.iv_home)
    ImageView ivHome;
    @BindView(R2.id.tv_home)
    TextView tvHome;
    @BindView(R2.id.iv_travel)
    ImageView ivTravel;
    @BindView(R2.id.tv_travel)
    TextView tvTravel;
    @BindView(R2.id.iv_camp)
    ImageView ivCamp;
    @BindView(R2.id.tv_camp)
    TextView tvCamp;
    @BindView(R2.id.iv_found)
    ImageView ivFound;
    @BindView(R2.id.tv_found)
    TextView tvFound;
    @BindView(R2.id.iv_mine)
    ImageView ivMine;
    @BindView(R2.id.tv_mine)
    TextView tvMine;
    private TabAdapter mAdapter;
    private final int TYPE_HOME_PAGE = 0;//首页
    private final int TYPE_TRAVEL = 1;//旅行
    private final int TYPE_CAMP = 2;//营地
    private final int TYPE_FOUND = 3;//旅行
    private final int TYPE_MINE = 4;//我的

    public static Intent getIntent(Context context) {
        return new Intent(context, HomeActivity.class);
    }

    ;

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    protected int setLayout() {
        return R.layout.rv_act_home;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);
        mAdapter = new TabAdapter(getSupportFragmentManager(), getListFragment());
        viewPager.setAdapter(mAdapter);
//        viewPager.setOffscreenPageLimit(3);
        setCurrent(TYPE_HOME_PAGE);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }


    @OnClick({R2.id.rl_home, R2.id.rl_travel, R2.id.rl_camp, R2.id.rl_found, R2.id.rl_mine})
    public void onViewClicked(View view) {
        ModuleChangeUtil.currentActivity = this;
        int i = view.getId();
        if (i == R.id.rl_home) {

            if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
                ModuleChangeUtil.getOnModuleChangedListener().onChanged(OnModuleChangedListener.MODULE_HOME);
                return;
            }
            setCurrent(TYPE_HOME_PAGE);
        } else if (i == R.id.rl_travel) {

            if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
                ModuleChangeUtil.getOnModuleChangedListener().onChanged(OnModuleChangedListener.MODULE_TRAVEL);
                return;
            }

            setCurrent(TYPE_TRAVEL);

        } else if (i == R.id.rl_camp) {
            if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
                ModuleChangeUtil.getOnModuleChangedListener().onChanged(OnModuleChangedListener.MODULE_CAMP);
                return;
            }

            setCurrent(TYPE_CAMP);

        } else if (i == R.id.rl_found) {
            if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
                ModuleChangeUtil.getOnModuleChangedListener().onChanged(OnModuleChangedListener.MODULE_FIND);
                return;
            }

            setCurrent(TYPE_FOUND);

        } else if (i == R.id.rl_mine) {

            if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
                ModuleChangeUtil.getOnModuleChangedListener().onChanged(OnModuleChangedListener.MODULE_MINE);
                return;
            }
            if (TextUtils.isEmpty(OkGoUtil.getToken())) {
                startActivity(LoginRvActivity.getIntent(mActivity));
                return;
            }
            setCurrent(TYPE_MINE);

        }
    }

    private List<BaseWrapperFragment> getListFragment() {
        List<BaseWrapperFragment> list = new ArrayList<>();
        list.add(HomePageFragment.getInstance(TYPE_HOME_PAGE));
        list.add(TravelFragment.getInstance(TYPE_TRAVEL));
        list.add(CampFragment.getInstance(TYPE_CAMP));
        list.add(FoundFragment.getInstance(TYPE_FOUND));
        list.add(MineFragment.getInstance(TYPE_MINE));
        return list;
    }

    /**
     * 设置切换
     *
     * @param index
     */
    private void setCurrent(int index) {
        setViewStyle(ivHome, tvHome, index == TYPE_HOME_PAGE);
        setViewStyle(ivTravel, tvTravel, index == TYPE_TRAVEL);
        setViewStyle(ivCamp, tvCamp, index == TYPE_CAMP);
        setViewStyle(ivFound, tvFound, index == TYPE_FOUND);
        setViewStyle(ivMine, tvMine, index == TYPE_MINE);
        viewPager.setCurrentItem(index, false);
    }

    /**
     * 设置view的样式
     */
    private void setViewStyle(ImageView imageView, TextView textView, boolean isTrue) {
        imageView.setSelected(isTrue);
        textView.setTextColor(ContextCompat.getColor(this, isTrue ? R.color.colorAuxiliaryYellow : R.color.textMain));
    }
}
