package com.rv.home.rv.module.basic;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;

import com.frame.rv.RvFrameConfig;
import com.ruiwenliu.wrapper.presenter.MvpPresenter;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.R;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.ui.login.bean.RegisteredBean;
import com.rv.home.rv.module.ui.main.HomeActivity;
import com.rv.home.rv.module.ui.main.home.CarDetailActivity;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareAPI;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.utils.SocializeUtils;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Created :Auser
 * Date: 2019/5/15.
 * Desc:登录基类
 */

public abstract class BaseLoginActivity<P extends MvpPresenter> extends BaseStatusActivity<P> implements UMAuthListener {
    public ProgressDialog dialog;

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        dialog = new ProgressDialog(this);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        UMShareAPI.get(mActivity).onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        UMShareAPI.get(mActivity).release();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        UMShareAPI.get(mActivity).onSaveInstanceState(outState);
    }

    @Override
    public void onStart(SHARE_MEDIA platform) {
        SocializeUtils.safeShowDialog(dialog);
    }

    @Override
    public void onError(SHARE_MEDIA platform, int action, Throwable t) {
        SocializeUtils.safeCloseDialog(dialog);
        showToast(mActivity.getString(R.string.rv_login_authorization_failure) + t.getMessage());
    }

    @Override
    public void onCancel(SHARE_MEDIA platform, int action) {
        SocializeUtils.safeCloseDialog(dialog);
//        Toast.makeText(LoginActivity.this, "取消了", Toast.LENGTH_LONG).show();
    }

    public void umLogin(SHARE_MEDIA share_media) {
        UMShareAPI.get(mActivity).getPlatformInfo(mActivity, share_media, this);
    }

    /**
     * 第三方登录
     *
     * @param username
     * @param mobilecode
     * @param password
     * @param nickname
     * @param headimgurl
     * @param openid
     * @param type
     */
    public void otherLoginBind(String username, String mobilecode, String password, String nickname, String headimgurl, String openid, int type, int isQQ, String uid) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("username", username);
        map.put("mobilecode", mobilecode);
        map.put("password", password);
        map.put("nickname", nickname);
        map.put("headimgurl", headimgurl);
        map.put("openid", openid);
        map.put("type", type);
        map.put("isQQ", isQQ);
        if (isQQ == 0) {
            map.put("unionid", uid);
        }
        mPresenter.postData(2, ApiConfig.HTTP_URL_OTHER_LOGIN_BIND, RegisteredBean.class, map, true);
    }

    public void processLoginData(RegisteredBean bean) {
        RegisteredBean registeredBean = bean;
        UtilsManager.getInstance(mActivity).setSharePreferencesSave("city_json").putString("username", registeredBean.getData().getUsername());
        UtilsManager.getInstance(mActivity).setSharePreferencesSave("city_json").putInt("userid", registeredBean.getData().getUserid());
        UtilsManager.getInstance(mActivity).setSharePreferencesSave("city_json").putString("token", registeredBean.getToken()).commit();
        OkGoUtil.setToken(registeredBean.getToken());
        UtilsManager.getInstance(mActivity).setShNull();
        switch (RvFrameConfig.RvFrameInfo.TYPE_LOGIN) {
            case 1:
                startActivity(CarDetailActivity.getIntent(mActivity, 1));
                break;
            default:
                startActivity(HomeActivity.getIntent(mActivity));
                break;
        }
        finish();
    }

}
