package com.frame.rv;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

public class BaseTitleBarLayout extends RelativeLayout {
    public BaseTitleBarLayout(Context context) {
        super(context);
        init(context);

    }

    public BaseTitleBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);

    }

    public BaseTitleBarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private ImageView backImageView;
    private TextView titleTextView;
    private TextView buttonView;

    private void init(Context context) {

        View view = LayoutInflater.from(context).inflate(R.layout.layout_title_bar, this, true);
        backImageView = view.findViewById(R.id.title_bar_back_image_view);
        titleTextView = view.findViewById(R.id.title_bar_text_view);
        buttonView = view.findViewById(R.id.title_bar_button_view);
        buttonView.setVisibility(GONE);
    }

    public void setButtonView(String text,OnClickListener listener) {
        buttonView.setVisibility(VISIBLE);
        buttonView.setText(text);
        buttonView.setOnClickListener(listener);
    }
    public void setBackClickListener(OnClickListener listener) {
        if (listener==null){
            setBackVisibility(GONE);
        }else {
            backImageView.setOnClickListener(listener);
        }
    }

    public void setBackVisibility(int visibility) {
        backImageView.setVisibility(visibility);
    }

    public void setTitleText(String text) {
        titleTextView.setText(text);
    }
}
