package com.frame.rv;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

public class BaseTabLayout extends FrameLayout {
    public BaseTabLayout(Context context) {
        super(context);
        init(context);

    }

    public BaseTabLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);

    }

    public BaseTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    ImageView ivHome;
    TextView tvHome;
    ImageView ivTravel;
    TextView tvTravel;
    ImageView ivCamp;
    TextView tvCamp;
    ImageView ivFound;
    TextView tvFound;
    ImageView ivMine;
    TextView tvMine;


    private View.OnClickListener listener = new OnClickListener() {
        @Override
        public void onClick(View v) {
            int i = v.getId();
            if (i == R.id.rl_home) {
                if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
                    ModuleChangeUtil.getOnModuleChangedListener().onChanged(OnModuleChangedListener.MODULE_HOME);
                }
            } else if (i == R.id.rl_travel) {

                if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
                    ModuleChangeUtil.getOnModuleChangedListener().onChanged(OnModuleChangedListener.MODULE_TRAVEL);
                }
            } else if (i == R.id.rl_camp) {
                if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
                    ModuleChangeUtil.getOnModuleChangedListener().onChanged(OnModuleChangedListener.MODULE_CAMP);
                }
            } else if (i == R.id.rl_found) {
                if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
                    ModuleChangeUtil.getOnModuleChangedListener().onChanged(OnModuleChangedListener.MODULE_FIND);
                }
            } else if (i == R.id.rl_mine) {
                if (ModuleChangeUtil.getOnModuleChangedListener() != null) {
                    ModuleChangeUtil.getOnModuleChangedListener().onChanged(OnModuleChangedListener.MODULE_MINE);
                }
            }
        }
    };


    private void init(Context context) {
        View view = LayoutInflater.from(context).inflate(R.layout.base_tab_layout, this, true);
        tvHome = view.findViewById(R.id.tv_home);
        tvTravel = view.findViewById(R.id.tv_travel);
        tvCamp = view.findViewById(R.id.tv_camp);
        tvFound = view.findViewById(R.id.tv_found);
        tvMine = view.findViewById(R.id.tv_mine);

        ivHome = view.findViewById(R.id.iv_home);
        ivTravel = view.findViewById(R.id.iv_travel);
        ivCamp = view.findViewById(R.id.iv_camp);
        ivFound = view.findViewById(R.id.iv_found);
        ivMine = view.findViewById(R.id.iv_mine);

        view.findViewById(R.id.rl_home).setOnClickListener(listener);
        view.findViewById(R.id.rl_travel).setOnClickListener(listener);
        view.findViewById(R.id.rl_camp).setOnClickListener(listener);
        view.findViewById(R.id.rl_found).setOnClickListener(listener);
        view.findViewById(R.id.rl_mine).setOnClickListener(listener);

    }

    private int currentTab = OnModuleChangedListener.MODULE_HOME;

    public void setCurrent(int tab) {
        currentTab = tab;
        setCurrentTab();
    }


    /**
     * 设置切换
     */
    private void setCurrentTab() {
        setViewStyle(ivHome, tvHome, currentTab == OnModuleChangedListener.MODULE_HOME);
        setViewStyle(ivTravel, tvTravel, currentTab == OnModuleChangedListener.MODULE_TRAVEL);
        setViewStyle(ivCamp, tvCamp, currentTab == OnModuleChangedListener.MODULE_CAMP);
        setViewStyle(ivFound, tvFound, currentTab == OnModuleChangedListener.MODULE_FIND);
        setViewStyle(ivMine, tvMine, currentTab == OnModuleChangedListener.MODULE_MINE);
    }

    /**
     * 设置view的样式
     */
    private void setViewStyle(ImageView imageView, TextView textView, boolean selected) {
        imageView.setSelected(selected);
        textView.setTextColor(ContextCompat.getColor(getContext(), selected ? R.color.colorH1 : R.color.colorTextH1));
    }


}
