package com.test.rv;

import com.base.utils.tools.android.IntentUtil;
import com.frame.base.FrameApp;
import com.frame.rv.ModuleChangeUtil;
import com.frame.rv.OnModuleChangedListener;
import com.rv.home.rv.module.ui.main.HomeActivity;
import com.rv.rvmine.MineActivity;
import com.rv.travel.TravelActivity;

public class ModuleUtil {
    private static int currentModule = -1;

    public static void register() {
        ModuleChangeUtil.setOnModuleChangedListener(new OnModuleChangedListener() {
            @Override
            public void onChanged(int module) {
                switch (module) {
                    case OnModuleChangedListener.MODULE_HOME:
                        if (currentModule == OnModuleChangedListener.MODULE_HOME) return;
                        if (ModuleChangeUtil.currentActivity != null) {
                            IntentUtil.goActivityWithAnimationAlpha(ModuleChangeUtil.currentActivity, HomeActivity.class);
                        } else {
                            IntentUtil.startActivity(FrameApp.getInstance(), HomeActivity.class);
                        }

                        break;
                    case OnModuleChangedListener.MODULE_TRAVEL:
                        if (currentModule == OnModuleChangedListener.MODULE_TRAVEL) return;
                        if (ModuleChangeUtil.currentActivity != null) {
                            IntentUtil.goActivityWithAnimationAlpha(ModuleChangeUtil.currentActivity, TravelActivity.class);
                        } else {
                            IntentUtil.startActivity(FrameApp.getInstance(), TravelActivity.class);
                        }
                        break;
                    case OnModuleChangedListener.MODULE_CAMP:
                        if (currentModule == OnModuleChangedListener.MODULE_CAMP) return;

                        //Toast.makeText(FrameApp.getInstance(), "营地", Toast.LENGTH_SHORT).show();

                        break;
                    case OnModuleChangedListener.MODULE_FIND:
                        if (currentModule == OnModuleChangedListener.MODULE_FIND) return;

                        //Toast.makeText(FrameApp.getInstance(), "发现", Toast.LENGTH_SHORT).show();

                        break;
                    case OnModuleChangedListener.MODULE_MINE:
                        if (currentModule == OnModuleChangedListener.MODULE_MINE) return;
                        if (ModuleChangeUtil.currentActivity != null) {
                            IntentUtil.goActivityWithAnimationAlpha(ModuleChangeUtil.currentActivity, MineActivity.class);
                        } else {
                            IntentUtil.startActivity(FrameApp.getInstance(), MineActivity.class);
                        }
                        break;
                }
                currentModule = module;
            }

            @Override
            public void onClear() {
                currentModule = -1;
            }
        });
    }
}
