package com.frame.base.glide;

import android.content.Context;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;


/**
 * Created by yuyife
 * glide加载图片
 */

public class GlideManager {

    private Context mContext;

    public GlideManager(Context context) {
        this.mContext = context.getApplicationContext();
    }

    private static GlideManager glideManager;

    public static GlideManager getInstance(Context context) {
        if (glideManager == null) {
            glideManager = new GlideManager(context);
        }
        return glideManager;
    }

    /**
     * 加载普通图片
     *
     * @param path
     * @param image
     */
    public void loadImage(Object path, ImageView image) {
        Glide.with(mContext)
                .load(path)
                .placeholder(com.base.resource.R.mipmap.glide_icon_placeholder)
                .error(com.base.resource.R.mipmap.glide_icon_error)
                .skipMemoryCache(true)
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .into(image);
    }

}
