package com.frame.base.browse;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.base.utils.R;
import com.base.utils.base.BaseActivity;

import java.util.ArrayList;
import java.util.List;

/**
 * 图片浏览
 * 使用方法：
 * 1.图片id集合，2.背景
 * ArrayList<Integer> images = new ArrayList<>();
 * images.add(R.drawable.item_image);
 * Bundle bundle = new Bundle();
 * bundle.putInt(ActivityImageBrowseInt.KEY_BACKGROUND,R.color.colorPrimary);
 * bundle.putIntegerArrayList(ActivityImageBrowseInt.KEY_IMAGE,images);
 * IntentUtil.startActivity(baseContext,ActivityImageBrowseInt.class,bundle);
 */

public class ActivityImageBrowseInt extends BaseActivity {
    final public static String KEY_IMAGE = "image";
    final public static String KEY_BACKGROUND = "background";

    FrameLayout root;
    ViewPager viewPager;
    RecyclerView recyclerView;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_image_browse);
        root = findViewById(R.id.activity_image_browse_root);
        viewPager = findViewById(R.id.activity_image_browse_view_pager);
        recyclerView = findViewById(R.id.activity_image_browse_recycler_view);
        onData();
        onView();
    }

    private List<FragmentImageBrowse> fragmentImageBrowseList;
    private AdapterRecyclerViewIndicator adapterRecyclerViewIndicator;

    @Override
    public void onData() {
        fragmentImageBrowseList = new ArrayList<>();
        int background = getIntent().getIntExtra(ActivityImageBrowseInt.KEY_BACKGROUND, 0);
        if (background != 0) {
            root.setBackgroundColor(ContextCompat.getColor(baseContext, background));
        }
        ArrayList<Integer> integers = getIntent().getIntegerArrayListExtra(ActivityImageBrowseInt.KEY_IMAGE);
        if (integers != null) {
            for (int imageRes : integers) {
                fragmentImageBrowseList.add(FragmentImageBrowse.getInstance(imageRes));
            }
        }

        viewPager.setAdapter(new AdapterViewPager(getSupportFragmentManager()));
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                index = position;
                adapterRecyclerViewIndicator.notifyDataSetChanged();
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        viewPager.setCurrentItem(0);
        if (fragmentImageBrowseList.size() >= 2) {
            recyclerView.setVisibility(View.VISIBLE);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(baseContext);
            linearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
            recyclerView.setLayoutManager(linearLayoutManager);
            adapterRecyclerViewIndicator = new AdapterRecyclerViewIndicator();
            recyclerView.setAdapter(adapterRecyclerViewIndicator);
        }
    }

    @Override
    public void onView() {

    }

    class AdapterViewPager extends FragmentPagerAdapter {


        public AdapterViewPager(FragmentManager fm) {
            super(fm);
        }

        @Override
        public Fragment getItem(int position) {
            return fragmentImageBrowseList.get(position);
        }

        @Override
        public int getCount() {
            return fragmentImageBrowseList.size();
        }
    }

    private static int index = 0;

    class AdapterRecyclerViewIndicator extends RecyclerView.Adapter<AdapterRecyclerViewIndicator.ViewHolderIndicator> {

        @Override
        public ViewHolderIndicator onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view = LayoutInflater.from(baseContext).inflate(R.layout.item_image_browse_indicator_point, parent, false);
            return new ViewHolderIndicator(view);
        }

        @Override
        public void onBindViewHolder(@NonNull ViewHolderIndicator holder, int position) {
            if (index == position) {
                holder.imageView.setImageResource(R.drawable.ic_indicator_point_select);
            } else {
                holder.imageView.setImageResource(R.drawable.ic_indicator_point_normal);
            }
        }

        @Override
        public int getItemCount() {
            return fragmentImageBrowseList.size();
        }

        class ViewHolderIndicator extends RecyclerView.ViewHolder {

            ImageView imageView;

            public ViewHolderIndicator(View itemView) {
                super(itemView);
                imageView = itemView.findViewById(R.id.item_image_browse_indicator_point_image_view);
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        index = 0;
    }
}
