/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize;

import android.content.Context;
import android.text.TextUtils;
import com.umeng.socialize.Config;
import com.umeng.socialize.interfaces.CompressListener;
import com.umeng.socialize.uploadlog.UMLog;
import com.umeng.socialize.utils.ContextUtil;

public final class UMShareConfig {
    public boolean isNeedAuthOnGetUserInfo;
    public static final int LINED_IN_BASE_PROFILE = 0;
    public static final int LINED_IN_FULL_PROFILE = 1;
    private int linkedInProfileScope;
    private boolean isOpenShareEditActivity = true;
    private String platformName = "";
    private boolean isHideQzoneOnQQFriendList;
    private boolean isOpenWXAnalytics = false;
    public static final int LINKED_IN_FRIEND_SCOPE_ANYONE = 0;
    public static final int LINKED_IN_FRIEND_SCOPE_CONNECTIONS = 1;
    private int linkedInFriendScope;
    private CompressListener compressListener;
    public static final int AUTH_TYPE_SSO = 1;
    public static final int AUTH_TYPE_WEBVIEW = 2;
    private int sinaAuthType;
    private int facebookAuthType;
    public static final int KAKAO_TALK = 0;
    public static final int KAKAO_STORY = 1;
    public static final int KAKAO_ACCOUNT = 2;
    private int kakaoAuthType;

    public UMShareConfig() {
        this.setShareToLinkedInFriendScope(Config.LinkedInShareCode);
        this.setShareToQQFriendQzoneItemHide(Config.QQWITHQZONE == 2);
        this.setShareToQQPlatformName(Config.appName);
        this.setSinaAuthType(1);
        this.setFacebookAuthType(1);
        this.setKaKaoAuthType(Config.KaKaoLoginType);
        this.isNeedAuthOnGetUserInfo(Config.isNeedAuth);
        this.setLinkedInProfileScope(Config.LinkedInProfileScope);
    }

    public UMShareConfig isNeedAuthOnGetUserInfo(boolean bl) {
        this.isNeedAuthOnGetUserInfo = bl;
        return this;
    }

    public UMShareConfig setLinkedInProfileScope(int n) {
        if (n == 0 || n == 1) {
            this.linkedInProfileScope = n;
        }
        return this;
    }

    public void setOpenWXAnalytics(boolean bl) {
        this.isOpenWXAnalytics = bl;
    }

    public boolean getOpenWXAnalytics() {
        return this.isOpenWXAnalytics;
    }

    public UMShareConfig isOpenShareEditActivity(boolean bl) {
        this.isOpenShareEditActivity = bl;
        UMLog.setIsOpenShareEdit(bl);
        return this;
    }

    public UMShareConfig setShareToQQPlatformName(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.platformName = string;
        }
        return this;
    }

    public UMShareConfig setShareToQQFriendQzoneItemHide(boolean bl) {
        this.isHideQzoneOnQQFriendList = bl;
        return this;
    }

    public UMShareConfig setShareToLinkedInFriendScope(int n) {
        if (n == 0 || n == 1) {
            this.linkedInFriendScope = n;
        }
        return this;
    }

    public UMShareConfig setSinaAuthType(int n) {
        if (n == 1 || n == 2) {
            this.sinaAuthType = n;
        }
        return this;
    }

    public UMShareConfig setFacebookAuthType(int n) {
        if (n == 1 || n == 2) {
            this.facebookAuthType = n;
        }
        return this;
    }

    public UMShareConfig setKaKaoAuthType(int n) {
        if (n == 0 || n == 2 || n == 1) {
            this.kakaoAuthType = n;
        }
        return this;
    }

    public final String getAppName() {
        CharSequence charSequence;
        Context context;
        if (TextUtils.isEmpty((CharSequence)this.platformName) && (context = ContextUtil.getContext()) != null && !TextUtils.isEmpty((CharSequence)(charSequence = context.getApplicationInfo().loadLabel(context.getPackageManager())))) {
            this.platformName = charSequence.toString();
        }
        return this.platformName;
    }

    public final boolean isHideQzoneOnQQFriendList() {
        return this.isHideQzoneOnQQFriendList;
    }

    public final boolean isLinkedInShareToAnyone() {
        return this.linkedInFriendScope == 0;
    }

    public final boolean isLinkedInProfileBase() {
        return this.linkedInProfileScope == 0;
    }

    public final boolean isKakaoAuthWithTalk() {
        return this.kakaoAuthType == 0;
    }

    public final boolean isKakaoAuthWithStory() {
        return this.kakaoAuthType == 1;
    }

    public final boolean isKakaoAuthWithAccount() {
        return this.kakaoAuthType == 2;
    }

    public final boolean isSinaAuthWithWebView() {
        return this.sinaAuthType == 2;
    }

    public final boolean isFacebookAuthWithWebView() {
        return this.facebookAuthType == 2;
    }

    public final boolean isNeedAuthOnGetUserInfo() {
        return this.isNeedAuthOnGetUserInfo;
    }

    public void setCompressListener(CompressListener compressListener) {
        this.compressListener = compressListener;
    }

    public CompressListener getCompressListener() {
        return this.compressListener;
    }

    public final boolean isOpenShareEditActivity() {
        return this.isOpenShareEditActivity;
    }
}

