/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard.widgets;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.umeng.socialize.shareboard.widgets.KeyEventCompat;
import com.umeng.socialize.shareboard.widgets.MotionEventCompat;
import com.umeng.socialize.shareboard.widgets.SocializePagerAdapter;
import com.umeng.socialize.shareboard.widgets.VelocityTrackerCompat;
import com.umeng.socialize.shareboard.widgets.ViewCompat;
import com.umeng.socialize.shareboard.widgets.WindowInsetsCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SocializeViewPager
extends ViewGroup {
    private static final String TAG = "ViewPager";
    private float mLastMotionX;
    private float mLastMotionY;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mCloseEnough;
    private static final int CLOSE_ENOUGH = 2;
    private int mTouchSlop;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private int mFlingDistance;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int DEFAULT_WIDTH_FACTOR = 1;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private int mOffscreenPageLimit = 1;
    private List<ItemInfo> mItems = new ArrayList<ItemInfo>();
    private final ItemInfo mTempItem = new ItemInfo();
    private int mCurPosition;
    private SocializePagerAdapter mAdapter;
    private PagerObserver mObserver;
    private int mExpectedAdapterCount;
    private boolean mPopulatePending;
    private boolean mFirstLayout;
    private int mRestoredCurItem = -1;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private int mDefaultGutterSize;
    private int mGutterSize;
    private float mFirstOffset;
    private float mLastOffset;
    private boolean mInLayout;
    private List<OnPageChangeListener> mOnPageChangeListeners;
    private boolean mCalledSuper;
    private boolean mIsScrollStarted;
    private Scroller mScroller;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private final Rect mTempRect = new Rect();
    private final Runnable mEndScrollRunnable = new Runnable(){

        @Override
        public void run() {
            SocializeViewPager.this.setScrollState(0);
            SocializeViewPager.this.populate();
        }
    };
    private int mScrollState = 0;
    private static final Comparator<ItemInfo> COMPARATOR = new Comparator<ItemInfo>(){

        @Override
        public int compare(ItemInfo lhs, ItemInfo rhs) {
            return lhs.position - rhs.position;
        }
    };
    private static final Interpolator sInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };
    static final int[] LAYOUT_ATTRS = new int[]{16842931};

    public SocializeViewPager(Context context) {
        super(context);
        this.init();
    }

    public SocializeViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SocializeViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public SocializeViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        float density = context.getResources().getDisplayMetrics().density;
        this.mTouchSlop = configuration.getScaledPagingTouchSlop();
        this.mMinimumVelocity = (int)(400.0f * density);
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mCloseEnough = (int)(2.0f * density);
        this.mFlingDistance = (int)(25.0f * density);
        this.mDefaultGutterSize = (int)(16.0f * density);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, new ViewCompat.OnApplyWindowInsetsListener(){

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat originalInsets) {
                WindowInsetsCompat applied = ViewCompat.onApplyWindowInsets(v, originalInsets);
                if (applied.isConsumed()) {
                    return applied;
                }
                Rect res = SocializeViewPager.this.mTempRect;
                res.left = applied.getSystemWindowInsetLeft();
                res.top = applied.getSystemWindowInsetTop();
                res.right = applied.getSystemWindowInsetRight();
                res.bottom = applied.getSystemWindowInsetBottom();
                int count = SocializeViewPager.this.getChildCount();
                for (int i = 0; i < count; ++i) {
                    WindowInsetsCompat childInsets = ViewCompat.dispatchApplyWindowInsets(SocializeViewPager.this.getChildAt(i), applied);
                    res.left = Math.min(childInsets.getSystemWindowInsetLeft(), res.left);
                    res.top = Math.min(childInsets.getSystemWindowInsetTop(), res.top);
                    res.right = Math.min(childInsets.getSystemWindowInsetRight(), res.right);
                    res.bottom = Math.min(childInsets.getSystemWindowInsetBottom(), res.bottom);
                }
                return applied.replaceSystemWindowInsets(res.left, res.top, res.right, res.bottom);
            }
        });
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 3 || action == 1) {
            this.resetTouch();
            return false;
        }
        if (action != 0) {
            if (this.mIsBeingDragged) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (action) {
            case 2: {
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = ev.findPointerIndex(activePointerId);
                float x = ev.getX(pointerIndex);
                float dx = x - this.mLastMotionX;
                float xDiff = Math.abs(dx);
                float y = ev.getY(pointerIndex);
                float yDiff = Math.abs(y - this.mInitialMotionY);
                if (dx != 0.0f && !this.isGutterDrag(this.mLastMotionX, dx) && this.canScroll((View)this, false, (int)dx, (int)x, (int)y)) {
                    this.mLastMotionX = x;
                    this.mLastMotionY = y;
                    this.mIsUnableToDrag = true;
                    return false;
                }
                if (xDiff > (float)this.mTouchSlop && xDiff * 0.5f > yDiff) {
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    this.mLastMotionX = dx > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                    this.mLastMotionY = y;
                } else if (yDiff > (float)this.mTouchSlop) {
                    this.mIsUnableToDrag = true;
                }
                if (!this.mIsBeingDragged || !this.performDrag(x)) break;
                ViewCompat.postInvalidateOnAnimation((View)this);
                break;
            }
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                this.mIsUnableToDrag = false;
                this.mIsScrollStarted = true;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState == 2 && Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) > this.mCloseEnough) {
                    this.mScroller.abortAnimation();
                    this.mPopulatePending = false;
                    this.populate();
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    break;
                }
                this.completeScroll(false);
                this.mIsBeingDragged = false;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0 && ev.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        boolean needsInvalidate = false;
        switch (action & 0xFF) {
            case 0: {
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                float x;
                if (!this.mIsBeingDragged) {
                    int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                    if (pointerIndex == -1) {
                        needsInvalidate = this.resetTouch();
                        break;
                    }
                    x = ev.getX(pointerIndex);
                    float xDiff = Math.abs(x - this.mLastMotionX);
                    float y = ev.getY(pointerIndex);
                    float yDiff = Math.abs(y - this.mLastMotionY);
                    if (xDiff > (float)this.mTouchSlop && xDiff > yDiff) {
                        this.mIsBeingDragged = true;
                        this.requestParentDisallowInterceptTouchEvent(true);
                        this.mLastMotionX = x - this.mInitialMotionX > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                        this.mLastMotionY = y;
                        this.setScrollState(1);
                        ViewParent parent = this.getParent();
                        if (parent != null) {
                            parent.requestDisallowInterceptTouchEvent(true);
                        }
                    }
                }
                if (!this.mIsBeingDragged) break;
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                x = ev.getX(activePointerIndex);
                needsInvalidate |= this.performDrag(x);
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int initialVelocity = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
                this.mPopulatePending = true;
                int width = this.getClientWidth();
                int scrollX = this.getScrollX();
                ItemInfo ii = this.infoForCurrentScrollPosition();
                float marginOffset = 0.0f;
                int currentPage = ii.position;
                float pageOffset = ((float)scrollX / (float)width - ii.offset) / 1.0f;
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                float x = ev.getX(activePointerIndex);
                int totalDelta = (int)(x - this.mInitialMotionX);
                int nextPage = this.determineTargetPage(currentPage, pageOffset, initialVelocity, totalDelta);
                this.setCurrentItemInternal(nextPage, true, true, initialVelocity);
                needsInvalidate = this.resetTouch();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.scrollToItem(this.mCurPosition, true, 0, false);
                needsInvalidate = this.resetTouch();
                break;
            }
            case 5: {
                float x;
                int index = MotionEventCompat.getActionIndex(ev);
                this.mLastMotionX = x = ev.getX(index);
                this.mActivePointerId = ev.getPointerId(index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastMotionX = ev.getX(ev.findPointerIndex(this.mActivePointerId));
            }
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
        return true;
    }

    private boolean resetTouch() {
        this.mActivePointerId = -1;
        this.endDrag();
        boolean needsInvalidate = true;
        return needsInvalidate;
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private boolean isGutterDrag(float x, float dx) {
        return x < (float)this.mGutterSize && dx > 0.0f || x > (float)(this.getWidth() - this.mGutterSize) && dx < 0.0f;
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dx, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                return true;
            }
        }
        return checkV && ViewCompat.canScrollHorizontally(v, -dx);
    }

    private void requestParentDisallowInterceptTouchEvent(boolean disallowIntercept) {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    private boolean performDrag(float x) {
        boolean needsInvalidate = false;
        float deltaX = this.mLastMotionX - x;
        this.mLastMotionX = x;
        float oldScrollX = this.getScrollX();
        float scrollX = oldScrollX + deltaX;
        int width = this.getClientWidth();
        float leftBound = (float)width * this.mFirstOffset;
        float rightBound = (float)width * this.mLastOffset;
        boolean leftAbsolute = true;
        boolean rightAbsolute = true;
        ItemInfo firstItem = this.mItems.get(0);
        ItemInfo lastItem = this.mItems.get(this.mItems.size() - 1);
        if (firstItem.position != 0) {
            leftAbsolute = false;
            leftBound = firstItem.offset * (float)width;
        }
        if (lastItem.position != this.mAdapter.getCount() - 1) {
            rightAbsolute = false;
            rightBound = lastItem.offset * (float)width;
        }
        if (scrollX < leftBound) {
            if (leftAbsolute) {
                needsInvalidate = true;
            }
            scrollX = leftBound;
        } else if (scrollX > rightBound) {
            if (rightAbsolute) {
                needsInvalidate = true;
            }
            scrollX = rightBound;
        }
        this.mLastMotionX += scrollX - (float)((int)scrollX);
        this.scrollTo((int)scrollX, this.getScrollY());
        this.pageScrolled((int)scrollX);
        return needsInvalidate;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex(ev);
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionX = ev.getX(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private int determineTargetPage(int currentPage, float pageOffset, int velocity, int deltaX) {
        int targetPage;
        if (Math.abs(deltaX) > this.mFlingDistance && Math.abs(velocity) > this.mMinimumVelocity) {
            targetPage = velocity > 0 ? currentPage : currentPage + 1;
        } else {
            float truncator = currentPage >= this.mCurPosition ? 0.4f : 0.6f;
            targetPage = currentPage + (int)(pageOffset + truncator);
        }
        if (this.mItems.size() > 0) {
            ItemInfo firstItem = this.mItems.get(0);
            ItemInfo lastItem = this.mItems.get(this.mItems.size() - 1);
            targetPage = Math.max(firstItem.position, Math.min(targetPage, lastItem.position));
        }
        return targetPage;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mEndScrollRunnable);
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(SocializeViewPager.getDefaultSize((int)0, (int)widthMeasureSpec), SocializeViewPager.getDefaultSize((int)0, (int)heightMeasureSpec));
        int measuredWidth = this.getMeasuredWidth();
        int maxGutterSize = measuredWidth / 10;
        this.mGutterSize = Math.min(maxGutterSize, this.mDefaultGutterSize);
        int childWidthSize = measuredWidth - this.getPaddingLeft() - this.getPaddingRight();
        int childHeightSize = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)0x40000000);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childHeightSize, (int)0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            LayoutParams lp;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || (lp = (LayoutParams)child.getLayoutParams()) != null && lp.isDecor) continue;
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)(childWidthSize * 1), (int)0x40000000);
            child.measure(widthSpec, childHeightMeasureSpec);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.recomputeScrollPosition(w, oldw, 0, 0);
        }
    }

    private void recomputeScrollPosition(int width, int oldWidth, int margin, int oldMargin) {
        if (oldWidth > 0 && !this.mItems.isEmpty()) {
            if (!this.mScroller.isFinished()) {
                this.mScroller.setFinalX(this.getCurrentItem() * this.getClientWidth());
            } else {
                int widthWithMargin = width - this.getPaddingLeft() - this.getPaddingRight() + margin;
                int oldWidthWithMargin = oldWidth - this.getPaddingLeft() - this.getPaddingRight() + oldMargin;
                int xpos = this.getScrollX();
                float pageOffset = (float)xpos / (float)oldWidthWithMargin;
                int newOffsetPixels = (int)(pageOffset * (float)widthWithMargin);
                this.scrollTo(newOffsetPixels, this.getScrollY());
            }
        } else {
            ItemInfo ii = this.infoForPosition(this.mCurPosition);
            float scrollOffset = ii != null ? Math.min(ii.offset, this.mLastOffset) : 0.0f;
            int scrollPos = (int)(scrollOffset * (float)(width - this.getPaddingLeft() - this.getPaddingRight()));
            if (scrollPos != this.getScrollX()) {
                this.completeScroll(false);
                this.scrollTo(scrollPos, this.getScrollY());
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int width = r - l;
        int height = b - t;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int childWidth = width - paddingLeft - paddingRight;
        for (int i = 0; i < count; ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.isDecor || (ii = this.infoForChild(child)) == null) continue;
            int loff = (int)((float)childWidth * ii.offset);
            int childLeft = paddingLeft + loff;
            int childTop = paddingTop;
            if (lp.needsMeasure) {
                lp.needsMeasure = false;
                int widthSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)childWidth * lp.widthFactor)), (int)0x40000000);
                int heightSpec = View.MeasureSpec.makeMeasureSpec((int)(height - paddingTop - paddingBottom), (int)0x40000000);
                child.measure(widthSpec, heightSpec);
            }
            child.layout(childLeft, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
        }
        if (this.mFirstLayout) {
            this.scrollToItem(this.mCurPosition, false, 0, false);
        }
        this.mFirstLayout = false;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (!this.checkLayoutParams(params)) {
            params = this.generateLayoutParams(params);
        }
        LayoutParams lp = (LayoutParams)params;
        lp.isDecor |= false;
        if (this.mInLayout) {
            if (lp != null && lp.isDecor) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            lp.needsMeasure = true;
            this.addViewInLayout(child, index, params);
        } else {
            super.addView(child, index, params);
        }
    }

    public void removeView(View view) {
        if (this.mInLayout) {
            this.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    private void populate() {
        this.populate(this.mCurPosition);
    }

    private void populate(int position) {
        ItemInfo ii;
        ItemInfo oldCurInfo = null;
        if (this.mCurPosition != position) {
            oldCurInfo = this.infoForPosition(this.mCurPosition);
            this.mCurPosition = position;
        }
        if (this.mAdapter == null) {
            return;
        }
        if (this.mPopulatePending) {
            return;
        }
        if (this.getWindowToken() == null) {
            return;
        }
        this.mAdapter.startUpdate(this);
        int pageLimit = this.mOffscreenPageLimit;
        int startPos = Math.max(0, this.mCurPosition - pageLimit);
        int N = this.mAdapter.getCount();
        int endPos = Math.min(N - 1, this.mCurPosition + pageLimit);
        if (N != this.mExpectedAdapterCount) {
            String resName;
            try {
                resName = this.getResources().getResourceName(this.getId());
            }
            catch (Resources.NotFoundException e) {
                resName = Integer.toHexString(this.getId());
            }
            throw new IllegalStateException("The application's SocializePagerAdapter changed the adapter's contents without calling SocializePagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + N + " Pager id: " + resName + " Pager class: " + ((Object)((Object)this)).getClass() + " Problematic adapter: " + this.mAdapter.getClass());
        }
        int curIndex = -1;
        ItemInfo curItem = null;
        for (curIndex = 0; curIndex < this.mItems.size(); ++curIndex) {
            ItemInfo ii2 = this.mItems.get(curIndex);
            if (ii2.position < this.mCurPosition) continue;
            if (ii2.position != this.mCurPosition) break;
            curItem = ii2;
            break;
        }
        if (curItem == null && N > 0) {
            curItem = this.addNewItem(this.mCurPosition, curIndex);
        }
        if (curItem != null) {
            float extraWidthLeft = 0.0f;
            int itemIndex = curIndex - 1;
            ii = itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
            int clientWidth = this.getClientWidth();
            float leftWidthNeeded = clientWidth <= 0 ? 0.0f : 1.0f + (float)this.getPaddingLeft() / (float)clientWidth;
            Log.d((String)TAG, (String)("populate leftWidthNeeded:" + leftWidthNeeded));
            for (int pos = this.mCurPosition - 1; pos >= 0; --pos) {
                if (extraWidthLeft >= leftWidthNeeded && pos < startPos) {
                    if (ii == null) break;
                    if (pos != ii.position || ii.scrolling) continue;
                    this.mItems.remove(itemIndex);
                    this.mAdapter.destroyItem(this, pos, ii.object);
                    --curIndex;
                    ii = --itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
                    continue;
                }
                if (ii != null && pos == ii.position) {
                    extraWidthLeft += 1.0f;
                    ii = --itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
                    continue;
                }
                this.addNewItem(pos, itemIndex + 1);
                extraWidthLeft += 1.0f;
                ++curIndex;
                ii = itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
            }
            float extraWidthRight = 1.0f;
            itemIndex = curIndex + 1;
            if (extraWidthRight < 2.0f) {
                ii = itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                float rightWidthNeeded = clientWidth <= 0 ? 0.0f : (float)this.getPaddingRight() / (float)clientWidth + 2.0f;
                for (int pos = this.mCurPosition + 1; pos < N; ++pos) {
                    if (extraWidthRight >= rightWidthNeeded && pos > endPos) {
                        if (ii == null) break;
                        if (pos != ii.position || ii.scrolling) continue;
                        this.mItems.remove(itemIndex);
                        this.mAdapter.destroyItem(this, pos, ii.object);
                        ii = itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                        continue;
                    }
                    if (ii != null && pos == ii.position) {
                        extraWidthRight += 1.0f;
                        ii = ++itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                        continue;
                    }
                    this.addNewItem(pos, itemIndex);
                    extraWidthRight += 1.0f;
                    ii = ++itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                }
            }
            this.calculatePageOffsets(curItem, curIndex, oldCurInfo);
        }
        this.mAdapter.setPrimaryItem(this, this.mCurPosition, curItem != null ? curItem.object : null);
        this.mAdapter.finishUpdate(this);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ItemInfo ii3;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.childIndex = i;
            if (lp.isDecor || lp.widthFactor != 0.0f || (ii3 = this.infoForChild(child)) == null) continue;
            lp.widthFactor = 1.0f;
            lp.position = ii3.position;
        }
        if (this.hasFocus()) {
            View currentFocused = this.findFocus();
            ItemInfo itemInfo = ii = currentFocused != null ? this.infoForAnyChild(currentFocused) : null;
            if (ii == null || ii.position != this.mCurPosition) {
                View child;
                for (int i = 0; !(i >= this.getChildCount() || (ii = this.infoForChild(child = this.getChildAt(i))) != null && ii.position == this.mCurPosition && child.requestFocus(2)); ++i) {
                }
            }
        }
    }

    private void calculatePageOffsets(ItemInfo curItem, int curIndex, ItemInfo oldCurInfo) {
        int N = this.mAdapter.getCount();
        float marginOffset = 0.0f;
        if (oldCurInfo != null) {
            int pos;
            float offset;
            ItemInfo ii;
            int itemIndex;
            int oldCurPosition = oldCurInfo.position;
            if (oldCurPosition < curItem.position) {
                itemIndex = 0;
                ii = null;
                offset = oldCurInfo.offset + 1.0f + 0.0f;
                for (pos = oldCurPosition + 1; pos <= curItem.position && itemIndex < this.mItems.size(); ++pos) {
                    ii = this.mItems.get(itemIndex);
                    while (pos > ii.position && itemIndex < this.mItems.size() - 1) {
                        ii = this.mItems.get(++itemIndex);
                    }
                    while (pos < ii.position) {
                        offset += this.mAdapter.getPageWidth(pos) + 0.0f;
                        ++pos;
                    }
                    ii.offset = offset;
                    offset += 1.0f;
                }
            } else if (oldCurPosition > curItem.position) {
                itemIndex = this.mItems.size() - 1;
                ii = null;
                offset = oldCurInfo.offset;
                for (pos = oldCurPosition - 1; pos >= curItem.position && itemIndex >= 0; --pos) {
                    ii = this.mItems.get(itemIndex);
                    while (pos < ii.position && itemIndex > 0) {
                        ii = this.mItems.get(--itemIndex);
                    }
                    while (pos > ii.position) {
                        offset -= this.mAdapter.getPageWidth(pos) + 0.0f;
                        --pos;
                    }
                    ii.offset = offset -= 1.0f;
                }
            }
        }
        int itemCount = this.mItems.size();
        float offset = curItem.offset;
        int pos = curItem.position - 1;
        this.mFirstOffset = curItem.position == 0 ? curItem.offset : -3.4028235E38f;
        this.mLastOffset = curItem.position == N - 1 ? curItem.offset + 1.0f - 1.0f : Float.MAX_VALUE;
        int i = curIndex - 1;
        while (i >= 0) {
            ItemInfo ii = this.mItems.get(i);
            while (pos > ii.position) {
                offset -= this.mAdapter.getPageWidth(pos--) + 0.0f;
            }
            ii.offset = offset -= 1.0f;
            if (ii.position == 0) {
                this.mFirstOffset = offset;
            }
            --i;
            --pos;
        }
        offset = curItem.offset + 1.0f + 0.0f;
        pos = curItem.position + 1;
        i = curIndex + 1;
        while (i < itemCount) {
            ItemInfo ii = this.mItems.get(i);
            while (pos < ii.position) {
                offset += this.mAdapter.getPageWidth(pos++) + 0.0f;
            }
            if (ii.position == N - 1) {
                this.mLastOffset = offset + 1.0f - 1.0f;
            }
            ii.offset = offset;
            offset += 1.0f;
            ++i;
            ++pos;
        }
    }

    public void setAdapter(SocializePagerAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.setViewPagerObserver(null);
            this.mAdapter.startUpdate(this);
            for (int i = 0; i < this.mItems.size(); ++i) {
                ItemInfo ii = this.mItems.get(i);
                this.mAdapter.destroyItem(this, ii.position, ii.object);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeAllViews();
            this.mCurPosition = 0;
            this.scrollTo(0, 0);
        }
        this.mAdapter = adapter;
        this.mExpectedAdapterCount = 0;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.setViewPagerObserver(this.mObserver);
            this.mPopulatePending = false;
            boolean wasFirstLayout = this.mFirstLayout;
            this.mFirstLayout = true;
            this.mExpectedAdapterCount = this.mAdapter.getCount();
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else if (!wasFirstLayout) {
                this.populate();
            } else {
                this.requestLayout();
            }
        }
    }

    void dataSetChanged() {
        int adapterCount;
        this.mExpectedAdapterCount = adapterCount = this.mAdapter.getCount();
        boolean needPopulate = this.mItems.size() < this.mOffscreenPageLimit * 2 + 1 && this.mItems.size() < adapterCount;
        int newCurrItem = this.mCurPosition;
        boolean isUpdating = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            int newPos = this.mAdapter.getItemPosition(ii.object);
            if (newPos == -1) continue;
            if (newPos == -2) {
                this.mItems.remove(i);
                --i;
                if (!isUpdating) {
                    this.mAdapter.startUpdate(this);
                    isUpdating = true;
                }
                this.mAdapter.destroyItem(this, ii.position, ii.object);
                needPopulate = true;
                if (this.mCurPosition != ii.position) continue;
                newCurrItem = Math.max(0, Math.min(this.mCurPosition, adapterCount - 1));
                needPopulate = true;
                continue;
            }
            if (ii.position == newPos) continue;
            if (ii.position == this.mCurPosition) {
                newCurrItem = newPos;
            }
            ii.position = newPos;
            needPopulate = true;
        }
        if (isUpdating) {
            this.mAdapter.finishUpdate(this);
        }
        Collections.sort(this.mItems, COMPARATOR);
        if (needPopulate) {
            this.setCurrentItemInternal(newCurrItem, false, true);
            this.requestLayout();
        }
    }

    public void setCurrentItem(int item) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, !this.mFirstLayout, false);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, smoothScroll, false);
    }

    public int getCurrentItem() {
        return this.mCurPosition;
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always) {
        this.setCurrentItemInternal(item, smoothScroll, always, 0);
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always, int velocity) {
        boolean dispatchSelected;
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            return;
        }
        if (!always && this.mCurPosition == item && this.mItems.size() != 0) {
            return;
        }
        if (item < 0) {
            item = 0;
        } else if (item >= this.mAdapter.getCount()) {
            item = this.mAdapter.getCount() - 1;
        }
        int pageLimit = this.mOffscreenPageLimit;
        if (item > this.mCurPosition + pageLimit || item < this.mCurPosition - pageLimit) {
            for (int i = 0; i < this.mItems.size(); ++i) {
                this.mItems.get((int)i).scrolling = true;
            }
        }
        boolean bl = dispatchSelected = this.mCurPosition != item;
        if (this.mFirstLayout) {
            this.mCurPosition = item;
            if (dispatchSelected) {
                this.dispatchOnPageSelected(item);
            }
            this.requestLayout();
        } else {
            this.populate(item);
            this.scrollToItem(item, smoothScroll, velocity, dispatchSelected);
        }
    }

    private void scrollToItem(int item, boolean smoothScroll, int velocity, boolean dispatchSelected) {
        ItemInfo curInfo = this.infoForPosition(item);
        int destX = 0;
        if (curInfo != null) {
            int width = this.getClientWidth();
            destX = (int)((float)width * Math.max(this.mFirstOffset, Math.min(curInfo.offset, this.mLastOffset)));
        }
        if (smoothScroll) {
            this.smoothScrollTo(destX, 0, velocity);
            if (dispatchSelected) {
                this.dispatchOnPageSelected(item);
            }
        } else {
            if (dispatchSelected) {
                this.dispatchOnPageSelected(item);
            }
            this.completeScroll(false);
            this.scrollTo(destX, 0);
            this.pageScrolled(destX);
        }
    }

    void smoothScrollTo(int x, int y) {
        this.smoothScrollTo(x, y, 0);
    }

    void smoothScrollTo(int x, int y, int velocity) {
        int duration;
        int sx;
        boolean wasScrolling;
        if (this.getChildCount() == 0) {
            return;
        }
        boolean bl = wasScrolling = this.mScroller != null && !this.mScroller.isFinished();
        if (wasScrolling) {
            sx = this.mIsScrollStarted ? this.mScroller.getCurrX() : this.mScroller.getStartX();
            this.mScroller.abortAnimation();
        } else {
            sx = this.getScrollX();
        }
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        if (dx == 0 && dy == 0) {
            this.completeScroll(false);
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollState(2);
        int width = this.getClientWidth();
        int halfWidth = width / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dx) / (float)width);
        float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
        velocity = Math.abs(velocity);
        if (velocity > 0) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
        } else {
            float pageWidth = (float)width * this.mAdapter.getPageWidth(this.mCurPosition);
            float pageDelta = (float)Math.abs(dx) / pageWidth;
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, 600);
        this.mIsScrollStarted = false;
        this.mScroller.startScroll(sx, sy, dx, dy, duration);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void computeScroll() {
        this.mIsScrollStarted = true;
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
                if (!this.pageScrolled(x)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, y);
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll(true);
    }

    private void completeScroll(boolean postEvents) {
        boolean needPopulate;
        boolean bl = needPopulate = this.mScrollState == 2;
        if (needPopulate) {
            boolean wasScrolling;
            boolean bl2 = wasScrolling = !this.mScroller.isFinished();
            if (wasScrolling) {
                this.mScroller.abortAnimation();
                int oldX = this.getScrollX();
                int oldY = this.getScrollY();
                int x = this.mScroller.getCurrX();
                int y = this.mScroller.getCurrY();
                if (oldX != x || oldY != y) {
                    this.scrollTo(x, y);
                    if (x != oldX) {
                        this.pageScrolled(x);
                    }
                }
            }
        }
        this.mPopulatePending = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!ii.scrolling) continue;
            needPopulate = true;
            ii.scrolling = false;
        }
        if (needPopulate) {
            if (postEvents) {
                ViewCompat.postOnAnimation((View)this, this.mEndScrollRunnable);
            } else {
                this.mEndScrollRunnable.run();
            }
        }
    }

    private boolean pageScrolled(int xpos) {
        int width;
        if (this.mItems.size() == 0) {
            if (this.mFirstLayout) {
                return false;
            }
            this.mCalledSuper = false;
            this.onPageScrolled(0, 0.0f, 0);
            if (!this.mCalledSuper) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
            return false;
        }
        ItemInfo ii = this.infoForCurrentScrollPosition();
        int widthWithMargin = width = this.getClientWidth();
        int currentPage = ii.position;
        float pageOffset = ((float)xpos / (float)width - ii.offset) / 1.0f;
        int offsetPixels = (int)(pageOffset * (float)widthWithMargin);
        this.mCalledSuper = false;
        this.onPageScrolled(currentPage, pageOffset, offsetPixels);
        if (!this.mCalledSuper) {
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
        return true;
    }

    protected void onPageScrolled(int position, float offset, int offsetPixels) {
        this.dispatchOnPageScrolled(position, offset, offsetPixels);
        this.mCalledSuper = true;
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    void setScrollState(int newState) {
        if (this.mScrollState == newState) {
            return;
        }
        this.mScrollState = newState;
        this.dispatchOnScrollStateChanged(newState);
    }

    private void dispatchOnPageScrolled(int position, float offset, int offsetPixels) {
        if (this.mOnPageChangeListeners != null) {
            int z = this.mOnPageChangeListeners.size();
            for (int i = 0; i < z; ++i) {
                OnPageChangeListener listener = this.mOnPageChangeListeners.get(i);
                if (listener == null) continue;
                listener.onPageScrolled(position, offset, offsetPixels);
            }
        }
    }

    private void dispatchOnPageSelected(int position) {
        if (this.mOnPageChangeListeners != null) {
            int z = this.mOnPageChangeListeners.size();
            for (int i = 0; i < z; ++i) {
                OnPageChangeListener listener = this.mOnPageChangeListeners.get(i);
                if (listener == null) continue;
                listener.onPageSelected(position);
            }
        }
    }

    private void dispatchOnScrollStateChanged(int state) {
        if (this.mOnPageChangeListeners != null) {
            int z = this.mOnPageChangeListeners.size();
            for (int i = 0; i < z; ++i) {
                OnPageChangeListener listener = this.mOnPageChangeListeners.get(i);
                if (listener == null) continue;
                listener.onPageScrollStateChanged(state);
            }
        }
    }

    public void addOnPageChangeListener(OnPageChangeListener listener) {
        if (this.mOnPageChangeListeners == null) {
            this.mOnPageChangeListeners = new ArrayList<OnPageChangeListener>();
        }
        this.mOnPageChangeListeners.add(listener);
    }

    public void removeOnPageChangeListener(OnPageChangeListener listener) {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.remove(listener);
        }
    }

    public void clearOnPageChangeListeners() {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.clear();
        }
    }

    private int getClientWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (event.getEventType() == 4096) {
            return super.dispatchPopulateAccessibilityEvent(event);
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurPosition || !child.dispatchPopulateAccessibilityEvent(event)) continue;
            return true;
        }
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    public boolean executeKeyEvent(KeyEvent event) {
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 21: {
                    handled = this.arrowScroll(17);
                    break;
                }
                case 22: {
                    handled = this.arrowScroll(66);
                    break;
                }
                case 61: {
                    if (Build.VERSION.SDK_INT < 11) break;
                    if (KeyEventCompat.hasNoModifiers(event)) {
                        handled = this.arrowScroll(2);
                        break;
                    }
                    if (!KeyEventCompat.hasModifiers(event, 1)) break;
                    handled = this.arrowScroll(1);
                }
            }
        }
        return handled;
    }

    public boolean arrowScroll(int direction) {
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        } else if (currentFocused != null) {
            boolean isChild = false;
            ViewParent parent = currentFocused.getParent();
            while (parent instanceof ViewGroup) {
                if (parent == this) {
                    isChild = true;
                    break;
                }
                parent = parent.getParent();
            }
            if (!isChild) {
                StringBuilder sb = new StringBuilder();
                sb.append(currentFocused.getClass().getSimpleName());
                ViewParent parent2 = currentFocused.getParent();
                while (parent2 instanceof ViewGroup) {
                    sb.append(" => ").append(parent2.getClass().getSimpleName());
                    parent2 = parent2.getParent();
                }
                Log.e((String)TAG, (String)("arrowScroll tried to find focus based on non-child current focused view " + sb.toString()));
                currentFocused = null;
            }
        }
        boolean handled = false;
        View nextFocused = FocusFinder.getInstance().findNextFocus((ViewGroup)this, currentFocused, direction);
        if (nextFocused != null && nextFocused != currentFocused) {
            if (direction == 17) {
                int nextLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)nextFocused).left;
                int currLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)currentFocused).left;
                handled = currentFocused != null && nextLeft >= currLeft ? this.pageLeft() : nextFocused.requestFocus();
            } else if (direction == 66) {
                int nextLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)nextFocused).left;
                int currLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)currentFocused).left;
                handled = currentFocused != null && nextLeft <= currLeft ? this.pageRight() : nextFocused.requestFocus();
            }
        } else if (direction == 17 || direction == 1) {
            handled = this.pageLeft();
        } else if (direction == 66 || direction == 2) {
            handled = this.pageRight();
        }
        if (handled) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)direction));
        }
        return handled;
    }

    private Rect getChildRectInPagerCoordinates(Rect outRect, View child) {
        if (outRect == null) {
            outRect = new Rect();
        }
        if (child == null) {
            outRect.set(0, 0, 0, 0);
            return outRect;
        }
        outRect.left = child.getLeft();
        outRect.right = child.getRight();
        outRect.top = child.getTop();
        outRect.bottom = child.getBottom();
        ViewParent parent = child.getParent();
        while (parent instanceof ViewGroup && parent != this) {
            ViewGroup group = (ViewGroup)parent;
            outRect.left += group.getLeft();
            outRect.right += group.getRight();
            outRect.top += group.getTop();
            outRect.bottom += group.getBottom();
            parent = group.getParent();
        }
        return outRect;
    }

    boolean pageLeft() {
        if (this.mCurPosition > 0) {
            this.setCurrentItem(this.mCurPosition - 1, true);
            return true;
        }
        return false;
    }

    boolean pageRight() {
        if (this.mAdapter != null && this.mCurPosition < this.mAdapter.getCount() - 1) {
            this.setCurrentItem(this.mCurPosition + 1, true);
            return true;
        }
        return false;
    }

    ItemInfo addNewItem(int position, int index) {
        ItemInfo ii = new ItemInfo();
        ii.position = position;
        ii.object = this.mAdapter.instantiateItem(this, position);
        if (index < 0 || index >= this.mItems.size()) {
            this.mItems.add(ii);
        } else {
            this.mItems.add(index, ii);
        }
        return ii;
    }

    ItemInfo infoForChild(View child) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!this.mAdapter.isViewFromObject(child, ii.object)) continue;
            return ii;
        }
        return null;
    }

    ItemInfo infoForAnyChild(View child) {
        ViewParent parent;
        while ((parent = child.getParent()) != this) {
            if (parent == null || !(parent instanceof View)) {
                return null;
            }
            child = (View)parent;
        }
        return this.infoForChild(child);
    }

    ItemInfo infoForPosition(int position) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (ii.position != position) continue;
            return ii;
        }
        return null;
    }

    private ItemInfo infoForCurrentScrollPosition() {
        int width = this.getClientWidth();
        float scrollOffset = width > 0 ? (float)this.getScrollX() / (float)width : 0.0f;
        float marginOffset = 0.0f;
        int lastPos = -1;
        float lastOffset = 0.0f;
        float lastWidth = 0.0f;
        boolean first = true;
        ItemInfo lastItem = null;
        for (int i = 0; i < this.mItems.size(); ++i) {
            float offset;
            ItemInfo ii = this.mItems.get(i);
            if (!first && ii.position != lastPos + 1) {
                ii = this.mTempItem;
                ii.offset = lastOffset + lastWidth + 0.0f;
                ii.position = lastPos + 1;
                --i;
            }
            float leftBound = offset = ii.offset;
            float rightBound = offset + 1.0f + 0.0f;
            if (first || scrollOffset >= leftBound) {
                if (scrollOffset < rightBound || i == this.mItems.size() - 1) {
                    return ii;
                }
            } else {
                return lastItem;
            }
            first = false;
            lastPos = ii.position;
            lastOffset = offset;
            lastItem = ii;
        }
        return lastItem;
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        int focusableCount = views.size();
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability != 393216) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ItemInfo ii;
                View child = this.getChildAt(i);
                if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurPosition) continue;
                child.addFocusables(views, direction, focusableMode);
            }
        }
        if (descendantFocusability != 262144 || focusableCount == views.size()) {
            if (!this.isFocusable()) {
                return;
            }
            if ((focusableMode & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                return;
            }
            if (views != null) {
                views.add((View)this);
            }
        }
    }

    public void addTouchables(ArrayList<View> views) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurPosition) continue;
            child.addTouchables(views);
        }
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        int end;
        int increment;
        int index;
        int count = this.getChildCount();
        if ((direction & 2) != 0) {
            index = 0;
            increment = 1;
            end = count;
        } else {
            index = count - 1;
            increment = -1;
            end = -1;
        }
        for (int i = index; i != end; i += increment) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurPosition || !child.requestFocus(direction, previouslyFocusedRect)) continue;
            return true;
        }
        return false;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return this.generateDefaultLayoutParams();
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public boolean isDecor;
        public int gravity;
        float widthFactor = 0.0f;
        boolean needsMeasure;
        int position;
        int childIndex;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, LAYOUT_ATTRS);
            this.gravity = a.getInteger(0, 48);
            a.recycle();
        }
    }

    private class PagerObserver
    extends DataSetObserver {
        PagerObserver() {
        }

        public void onChanged() {
            SocializeViewPager.this.dataSetChanged();
        }

        public void onInvalidated() {
            SocializeViewPager.this.dataSetChanged();
        }
    }

    static class ItemInfo {
        Object object;
        int position;
        boolean scrolling;
        float offset;

        ItemInfo() {
        }
    }

    public static interface OnPageChangeListener {
        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);

        public void onPageScrollStateChanged(int var1);
    }
}

