package com.xxrv.wallet.adapter;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.component.utils.DateUtils;
import com.xxrv.wallet.R;
import com.xxrv.wallet.bean.IncomeRecordsBean;

import java.util.List;

public class commissionListAdapter extends BaseQuickAdapter<IncomeRecordsBean.IncomeItem, BaseViewHolder> {

    public commissionListAdapter(@Nullable List<IncomeRecordsBean.IncomeItem> data) {
        super(R.layout.item_commission, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, IncomeRecordsBean.IncomeItem item) {
        StringBuilder buffer = new StringBuilder();

        if (item.getStatus() == 0) {  //类别：0-正；1-负(退款时)
            buffer.append(dealName(item.getUsername())).append("成交").append(item.getPrice()).append("元");

        } else if (item.getStatus() == 1) {
            buffer.append(dealName(item.getUsername())).append("退款").append(item.getPrice()).append("元");
        }

        GlideManager.getInstance(mContext).loadCircleImage(item.getHeadUrl(), (ImageView) helper.getView(R.id.iv_avatar));
        helper.setText(R.id.tv_consume_name, buffer.toString());
        helper.setText(R.id.tv_income_time, DateUtils.timestampToString1(item.getCrtTime()));


        if (item.isShow()) {
            helper.setText(R.id.tv_amount, "取消订单");
            helper.setTextColor(R.id.tv_amount, mContext.getResources().getColor(R.color.colorGray));
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("+").append(item.getCommission()).append("元");
            helper.setText(R.id.tv_amount, builder.toString());
            helper.setTextColor(R.id.tv_amount, mContext.getResources().getColor(R.color.textGray));
        }

        if (TextUtils.isEmpty(item.getSellerStatus())) {
            helper.setGone(R.id.tv_status, false);
        } else {
            helper.setGone(R.id.tv_status, true);
            if ("0".equals(item.getSellerStatus())) {   //0未入账 1 已入账 2：取消
                helper.setBackgroundRes(R.id.tv_status, R.drawable.shape_rv_bg_income_not);
                helper.setText(R.id.tv_status, item.getStatusText());
            } else if ("1".equals(item.getSellerStatus())) {
                helper.setBackgroundRes(R.id.tv_status, R.drawable.shape_rv_bg_income_has);
                helper.setText(R.id.tv_status, item.getStatusText());
            } else if ("2".equals(item.getSellerStatus())) {
                helper.setBackgroundRes(R.id.tv_status, R.drawable.shape_rv_bg_income_cancel);
                helper.setText(R.id.tv_status, item.getStatusText());
            }
        }
    }


    private String dealName(String name) {
        if (!TextUtils.isEmpty(name)) {
            if (name.length() == 11) {
                return name.substring(0, 3) + "****" + name.substring(7, name.length());
            }
        }
        return name;
    }
}
