package com.xxrv.wallet.adapter;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.utils.DateUtils;
import com.xxrv.wallet.R;
import com.xxrv.wallet.bean.WalletcathListBean;
import java.util.List;

public class WalletCathAdapter extends BaseQuickAdapter<WalletcathListBean.ItemWalletcath, BaseViewHolder> {

    public WalletCathAdapter(@Nullable List<WalletcathListBean.ItemWalletcath> data) {
        super(R.layout.item_commision, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, WalletcathListBean.ItemWalletcath item) {
        helper.setText(R.id.tv_amount, item.getAmount() + "元");
        helper.setText(R.id.tv_income_time, DateUtils.timestampToString1(item.getCrtTime()));
        helper.setText(R.id.tv_consume_name, item.getAccountNumberDesc());
    }


    private String dealName(String name) {
        if (!TextUtils.isEmpty(name)) {
            if (name.length() == 11) {
                return name.substring(0, 3) + "****" + name.substring(7, name.length());
            }
        }
        return name;
    }
}
