package com.rv.share.fragment;

import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.widget.LinearLayout;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.share.R;
import com.rv.share.R2;
import com.rv.share.adapter.ActivationListAdapter;
import com.rv.share.bean.InviteListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;

public class ActivationFragment extends BaseFragment<CommonPresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout refreshLayout;

    private ActivationListAdapter adapter;

    private int currentPage = 1;
    private int pageSize = 10;
    private int pageTotal = 0;

    public static ActivationFragment getInstance() {
        ActivationFragment fragment = new ActivationFragment();
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.fragment_income_record;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext(), LinearLayout.VERTICAL, false));
        adapter = new ActivationListAdapter(new ArrayList<InviteListBean.inviteMember>());
        adapter.setOnLoadMoreListener(this, recyclerView);
        refreshLayout.setHeaderView(new SimpleRefreshView(getContext()));
        refreshLayout.setOnSimpleRefreshListener(this);
        recyclerView.setAdapter(adapter);
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {

        getActivationData();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 0) {
            InviteListBean bean = (InviteListBean) result;
            if (bean.isRel() && bean.getData() != null && bean.getData().getInviteMembers() != null) {
                if (currentPage == 1) {
                    pageTotal = bean.getData().getTotalPage();
                    refreshLayout.onRefreshComplete();
                    if (bean.getData().getInviteMembers().size() == 0) {
                        adapter.setEmptyView(getEmptyView(recyclerView, -1, getString(R.string.rv_select_not_data)));
                        adapter.notifyDataSetChanged();
                    } else {
                        adapter.setNewData(bean.getData().getInviteMembers());
                    }
                } else {
                    adapter.addData(bean.getData().getInviteMembers());
                    adapter.loadMoreComplete();
                }
            }
        }
    }

    @Override
    public void onShowError(String errorMsg, int errorType) {
        super.onShowError(errorMsg, errorType);
        if (currentPage == 1)
            refreshLayout.onRefreshComplete();
    }

    private void getActivationData() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());

            Map<String, Object> map = new HashMap<>();
            map.put("state", 1);
            map.put("page", currentPage);
            map.put("limit", pageSize);
            mPresenter.getData(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URL_INVITE_LIST, InviteListBean.class, map, header, true);
        }
    }

    @Override
    public void onLoadMoreRequested() {
        if (currentPage >= pageTotal) {
            adapter.loadMoreEnd();
        } else {
            currentPage++;
            getActivationData();
        }
    }

    @Override
    public void onRefresh() {
        currentPage = 1;
        getActivationData();
    }
}
