package com.rv.member.adapter;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.rv.component.utils.DisplayUtil;
import com.rv.member.R;
import com.rv.member.bean.MemberListBean;

import java.math.BigDecimal;
import java.util.List;

public class GridMemerAdapter extends BaseAdapter {

    private int selecPosition;
    private Context mContext;
    private List<MemberListBean.MemberCard> mData;
    private SelectListener mListener;

    public interface SelectListener {
        void select(MemberListBean.MemberCard memberCard);
    }

    public GridMemerAdapter(Context context, List<MemberListBean.MemberCard> lists, SelectListener listener) {
        this.mContext = context;
        this.mData = lists;
        this.mListener = listener;
    }

    public void setDate(List<MemberListBean.MemberCard> data) {
        mData = data;
        notifyDataSetChanged();
    }

    @Override
    public int getCount() {
        return mData.size();
    }

    @Override
    public Object getItem(int i) {
        return mData.get(i);
    }

    @Override
    public long getItemId(int i) {
        return i;
    }

    @Override
    public View getView(final int i, View view, ViewGroup viewGroup) {
        final MemberListBean.MemberCard memberCard = mData.get(i);
        ViewHolder holder;
        if (view == null) {
            view = LayoutInflater.from(mContext).inflate(R.layout.item_member_detail_view, null);
            holder = new ViewHolder();
            holder.rl_content = view.findViewById(R.id.rl_content);
            holder.tv_discount = view.findViewById(R.id.tv_discount);
            holder.tv_free_day = view.findViewById(R.id.tv_free_day);
            holder.tv_price = view.findViewById(R.id.tv_price);
            holder.tv_type = view.findViewById(R.id.tv_type);
            view.setTag(holder);
        } else {
            holder = (ViewHolder) view.getTag();
        }

        String price = dealPrice(memberCard.getPrice());

        SpannableString s = new SpannableString("¥ " + price);

        s.setSpan(new AbsoluteSizeSpan(10, true), 0, 1, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        s.setSpan(new AbsoluteSizeSpan(20, true), 1, s.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);

//        if (selecPosition == i) {
//            s.setSpan(new ForegroundColorSpan(Color.parseColor("#FF5050")), 0, s.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
//        } else {
//            s.setSpan(new ForegroundColorSpan(Color.parseColor("#FF5050")), 0, s.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
//        }
        holder.tv_price.setText(s);

        holder.tv_discount.setText("永久" + memberCard.getDiscount() / 10 + "折租车");
        holder.tv_free_day.setText(memberCard.getNumber() + "天免费租车");
        holder.tv_type.setText(TextUtils.isEmpty(memberCard.getName()) ? "  " : memberCard.getName());

        if (selecPosition == i) {
//            if (i == 0) {
//                holder.rl_content.setBackgroundResource(R.drawable.bg_card_normal_member);
//            } else if (i == 1) {
//                holder.rl_content.setBackgroundResource(R.drawable.bg_card_gold_member);
//            } else if (i == 2) {
//                holder.rl_content.setBackgroundResource(R.drawable.bg_card_diamond_member);
//            }
            holder.rl_content.setBackgroundResource(R.drawable.bg_card_member_selected);
            holder.tv_type.setTextColor(Color.parseColor("#54311E"));
            holder.tv_type.setTextSize(18);
            holder.tv_discount.setTextColor(Color.parseColor("#54311E"));
            holder.tv_free_day.setTextColor(Color.parseColor("#54311E"));
        } else {
            holder.tv_type.setTextSize(16);
            holder.rl_content.setBackgroundResource(R.drawable.bg_member_unselect);
            holder.tv_type.setTextColor(Color.parseColor("#666666"));
            holder.tv_discount.setTextColor(Color.parseColor("#666666"));
            holder.tv_free_day.setTextColor(Color.parseColor("#666666"));
        }

        holder.rl_content.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                selecPosition = i;
                mListener.select(memberCard);
                notifyDataSetChanged();
            }
        });
        return view;
    }

    private String dealPrice(BigDecimal value){
        BigDecimal noZeros = value.stripTrailingZeros();
        return noZeros.toPlainString();
    }

    private class ViewHolder {
        LinearLayout rl_content;
        TextView tv_type;
        TextView tv_price;
        TextView tv_discount;
        TextView tv_free_day;
    }
}
