package com.rv.im.enums;

public enum CallTypeEnum {
    CONNECT_VOICE(100), // 发起语音通话
    CONNECTED_VOICE(101), // 接听语音通话
    NO_CONNECT_VOICE(102),// 拒绝语音通
    END_CONNECT_VOICE(103), // 结束语音通话

    CONNECT_VIDEO(110),// 发起视频通话
    CONNECTED_VIDEO(111),  // 接听视频通话
    NO_CONNECT_VIDEO(112),// 拒绝视频通话 || 对来电不响应(30s内)
    END_CONNECT_VIDEO(113), // 结束视频通话

    CALLING(123),// 通话中..
    CALL_BUSY(124), // 忙线中...
    CALL_NO_RESPONSE(125); // 对方不在线

    private int type;

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    CallTypeEnum(int type) {
        this.type = type;
    }
}
