package com.xxfc.discovery.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.utils.DateUtils;
import com.xxfc.discovery.R;
import com.xxfc.discovery.bean.DiscoveryCommentBean;

/**
 * 短视频评论
 */

public class DiscoveryVideoCommentAdapter extends BaseQuickAdapter<DiscoveryCommentBean.DataBean, BaseViewHolder> {

    public DiscoveryVideoCommentAdapter() {
        super(R.layout.rv_item_discovery_video_comment);
    }

    @Override
    protected void convert(BaseViewHolder helper, DiscoveryCommentBean.DataBean item) {
        if (item == null) {
            return;
        }

        helper.setText(R.id.iv_video_comment_name,item.getNickname());
        helper.setText(R.id.tv_video_comment_time, DateUtils.timestampToString3(item.getTime()));
        helper.setText(R.id.tv_video_comment_content,item.getBody());
    }
}
