package com.xxfc.discovery.adapter;

import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideApp;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.xxfc.discovery.R;
import com.xxfc.discovery.bean.DiscoveryRecommendBean;

/**
 * 短视频
 */

public class DiscoveryVideoAdapter extends BaseQuickAdapter<DiscoveryRecommendBean.DataBeanX.DataBean, BaseViewHolder> {

    public DiscoveryVideoAdapter() {
        super(R.layout.rv_item_discovery_video);
    }

    @Override
    protected void convert(BaseViewHolder helper, DiscoveryRecommendBean.DataBeanX.DataBean item) {
        if (item == null) {
            return;
        }
        if (item.getBody() != null && item.getBody().getImages() != null && item.getBody().getImages().size() > 0) {
            GlideApp.with(mContext)
                    .load(item.getBody().getImages().get(0).getOurl())
                    .placeholder(android.R.color.white)
                    .into((ImageView) helper.getView(R.id.thumb));
        }

        GlideManager.getInstance(mContext).loadImage(item.getPicUrl(), (ImageView) helper.getView(R.id.iv_video_avatar));
        if (item.getCount() != null) {
            helper.setText(R.id.tv_video_islike_number, item.getCount().getPraise());
            helper.setText(R.id.tv_video_comment_number, item.getCount().getComment());
            helper.setText(R.id.tv_video_share_number, item.getCount().getShare());
        }
        if ("1".equals(item.getIsPraise())) { //0：未点赞 1：已点赞
            helper.setImageResource(R.id.iv_video_islike, R.drawable.icon_discover_video_like);
        } else {
            helper.setImageResource(R.id.iv_video_islike, R.drawable.icon_discover_video_likeun);
        }

        helper.addOnClickListener(R.id.ll_item_video_comment);
        helper.addOnClickListener(R.id.ll_item_video_share);
    }
}
