package com.base.utils.tools.java;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;

/**
 * 格式化数字
 */

public class NumberUtil {

    /**
     * 返回带‘万’的数字
     */
    public static String formatWan(int targetInt, boolean isNeedNewLine) {
        int value = targetInt;
        if (value > 9999) {
            String text = String.valueOf(targetInt);
            String text1 = text.substring(0, text.length() - 4);
            String text2 = text.substring(text.length() - 4);
            if (isNeedNewLine) {
                return String.valueOf(text1 + "万\n" + text2);
            } else {
                return String.valueOf(text1 + "万" + text2);
            }
        } else if (value > -1 && value <= 9999) {
            return String.valueOf(targetInt);
        } else if (value <= -1 && value >= -9999) {
            return String.valueOf(targetInt);
        } else {
            value = Math.abs(value);
            String text = String.valueOf(value);
            String text1 = text.substring(0, text.length() - 4);
            String text2 = text.substring(text.length() - 4);
            if (isNeedNewLine) {
                return String.valueOf("-" + text1 + "万\n" + text2);
            } else {
                return String.valueOf("-" + text1 + "万" + text2);
            }
        }
    }

    /**
     * 保留两位小数
     */
    public static String formatDouble(double targetDouble) {
        DecimalFormat decimalFormat = new DecimalFormat("#########0.00");
        return decimalFormat.format(targetDouble);
    }

    /**
     * 当int 1需要 转换成01时调用
     */
    public static String formatInt00(int targetInt) {
        Format decimalFormat = new DecimalFormat("00");
        return decimalFormat.format(targetInt);
    }

    /**
     * 当int 1需要 转换成001时调用
     */
    public static String formatInt000(int targetInt) {
        Format decimalFormat = new DecimalFormat("000");
        return decimalFormat.format(targetInt);
    }

    /**
     * 当int 1需要 转换成0001时调用
     */
    public static String formatInt0000(int targetInt) {
        Format decimalFormat = new DecimalFormat("0000");
        return decimalFormat.format(targetInt);
    }

    /**
     * 当int 1需要 转换成00001时调用
     */
    public static String formatInt00000(int targetInt) {
        Format decimalFormat = new DecimalFormat("00000");
        return decimalFormat.format(targetInt);
    }

    /**
     * float保留一位小数（4舍5入）
     */
    public static float formatFloat1(float targetFloat) {
        BigDecimal b = new BigDecimal(targetFloat);
        return b.setScale(1, BigDecimal.ROUND_HALF_UP).floatValue();
    }
}
