package com.ruiwenliu.wrapper.util;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;

import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.R;
import com.ruiwenliu.wrapper.util.glide.GlideApp;
import com.ruiwenliu.wrapper.util.glide.GlideRoundTransform;

/**
 * Created :Auser
 * Date: 2019/5/16.
 * Desc:图片加载基类
 */

public class BaseGlideHolder extends BaseViewHolder {
    public BaseGlideHolder(View view) {
        super(view);
    }

    /**
     * 加载普通图片
     *
     * @param url
     * @param image
     */
    public void loadImage(Context context, String url, ImageView image) {
        GlideApp.with(context)
                .load(url)
                .placeholder(R.drawable.glide_icon_placeholder)
                .error(R.drawable.glide_icon_error)
                .apply(new RequestOptions()
                        .skipMemoryCache(true)
                        .diskCacheStrategy(DiskCacheStrategy.ALL))
                .into(image);
    }


    /**
     * 加载普通图片
     *
     * @param url
     * @param image
     */
    public void loadImage(Context context, String url, ImageView image, int x, int y) {
        GlideApp.with(context)
                .load(url)
                .placeholder(R.drawable.glide_icon_placeholder)
                .error(R.drawable.glide_icon_error)
                .apply(new RequestOptions()
                        .skipMemoryCache(true)
                        .diskCacheStrategy(DiskCacheStrategy.ALL).override(x, y))
                .into(image);
    }

    /**
     * 加载圆角图片
     *
     * @param url
     * @param image
     * @param round
     */
    public void loadRoundImage(Context context, String url, ImageView image, int round) {
        GlideApp.with(context)
                .load(url)
                .placeholder(R.drawable.glide_icon_placeholder)
                .error(R.drawable.glide_icon_error)
//                .apply(RequestOptions.bitmapTransform(new RoundedCorners(round)))
                .apply(RequestOptions.bitmapTransform(new GlideRoundTransform(context,round)))
                .into(image);
    }

    /**
     * 加载圆角图片
     * 通过RequestOptions扩展功能,override:采样率,因为ImageView就这么大,可以压缩图片,降低内存消耗,设置图片压缩比例
     *
     * @param url
     * @param image
     * @param round
     * @param x
     * @param y
     */
    public void loadRoundImage(Context context, String url, ImageView image, int round, int x, int y) {

        GlideApp.with(context)
                .load(url)
                .placeholder(R.drawable.glide_icon_placeholder)
                .error(R.drawable.glide_icon_error)
                .apply(RequestOptions.bitmapTransform(new RoundedCorners(round)).override(x, y))
                .into(image);
    }

    /**
     * 加载圆形图片
     *
     * @param url
     * @param image
     */
    public void loadCircleImage(Context context, String url, ImageView image) {
        GlideApp.with(context)
                .load(url)
                .placeholder(R.drawable.glide_icon_placeholder)
                .error(R.drawable.glide_icon_error)
                .apply(RequestOptions.circleCropTransform()
                        .diskCacheStrategy(DiskCacheStrategy.NONE)//不做磁盘缓存
                        .skipMemoryCache(true)//不做内存缓存
                )
                .into(image);
    }
}