package com.rv.version;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.Html;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.rv.version.bean.UpdateBean;

public class VersionUpdateDialog extends BaseDialog {

    public VersionUpdateDialog(@NonNull Context context) {
        super(context);

    }

    public VersionUpdateDialog(Context context, int themeResId) {
        super(context, themeResId);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_update_view;
    }

    public static class Builder {

        private Context mContext;
        private UpdateBean updateBean;
        private Button btn_update;
        private TextView txtContent;
        private TextView tv_version_name;
        private ImageView imgClose;

        private DownloadListener mListener;

        private UpdateForceDialog forceDialog;

        private UpdateUnforceDialog updateUnforceDialog;

        private VersionUpdateDialog dialog;

        public Builder(Context context, DownloadListener listener) {
            mContext = context;
            this.mListener = listener;
        }

        public interface DownloadListener {
            void download();
        }

        public Builder show() {
            final VersionUpdateDialog dialog = create();
            dialog.show();
            return this;
        }

        public Builder setData(UpdateBean updateBean) {
            this.updateBean = updateBean;
            return this;
        }

        /**
         * 创建定制的对话框
         */
        public VersionUpdateDialog create() {
            LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            dialog = new VersionUpdateDialog(mContext, R.style.DialogActivityTheme);
            // 获取对话框的布局
            View layout = inflater.inflate(R.layout.dialog_update_view, null);
            // 为对话框添加布局和设置大小
            dialog.addContentView(layout, new WindowManager.LayoutParams(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT));
            this.tv_version_name = layout.findViewById(R.id.tv_version_name);
            this.txtContent = layout.findViewById(R.id.txt_content);
            this.btn_update = layout.findViewById(R.id.btn_update);
            this.imgClose = layout.findViewById(R.id.img_close);

            this.btn_update.setOnClickListener(view -> {
                if (mListener != null) {
                    mListener.download();
                }
            });

            this.imgClose.setOnClickListener(view -> dialog.dismiss());

            if (this.updateBean != null) {
                if (!TextUtils.isEmpty(this.updateBean.getUpdateInfo())) {
                    txtContent.setText(Html.fromHtml(this.updateBean.getUpdateInfo()));
                }

                if (!TextUtils.isEmpty(this.updateBean.getServerVersionName())) {
                    tv_version_name.setText(this.updateBean.getServerVersionName());
                }
                if (updateBean.getForce()) {
                    this.imgClose.setVisibility(View.GONE);
                } else {
                    this.imgClose.setVisibility(View.VISIBLE);
                }
            }

            //默认不能点击对话框其他区域退出 和按返回键退出
            dialog.setCancelable(false);
            dialog.setContentView(layout);
            return dialog;
        }

        public void showDownDialog() {
            if (mContext instanceof Activity && "MainActivity".equals(((Activity) mContext).getClass().getSimpleName()))
                if (updateBean.getForce()) { // 强制更新
                    if (forceDialog == null)
                        forceDialog = new UpdateForceDialog(mContext, R.style.DialogActivityTheme);
                    forceDialog.show();
                } else {
                    if (updateUnforceDialog == null)
                        updateUnforceDialog = new UpdateUnforceDialog(mContext, R.style.DialogActivityTheme);
                    updateUnforceDialog.show();
                }
            DownListenerManager.getInstance().notifyPendChange();
            dialog.dismiss();
        }
    }
}
