package com.rv.share.view;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.widget.TextView;

import java.util.Timer;
import java.util.TimerTask;

public class MyTimerView extends TextView {

    private long efftiveTime;
    private long crTime;
    private Timer timer;
    private TimerListener mListener;

    public MyTimerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    /********
     * @param efftiveTime
     *         失效时间
     * @param crTime
     *         创建时间
     * @param listener
     */
    public void setTime(long efftiveTime, long crTime, TimerListener listener) {
        this.efftiveTime = efftiveTime;
        this.crTime = crTime;
        this.mListener = listener;
        showEffTime();
        startTimer();
    }

    private void showEffTime() {
        long mTime = efftiveTime - (System.currentTimeMillis() - crTime);
        if (mTime > 0) {
            int day = 0;
            int hour = 0;
            int min = 0;
            int seconds = (int) (mTime / 1000);
            if (seconds > 60) {
                min = seconds / 60;
                seconds = seconds % 60;
                if (min > 60) {
                    hour = min / 60;
                    min = min % 60;
                    if (hour > 24) {
                        day = hour / 24;
                        hour = hour % 24;
                    }
                }
            }
            StringBuilder builder = new StringBuilder();
            builder.append("剩余");
            if (day > 0) {
                builder.append(day + "天 ");
            }

            dealTime(true, hour, builder);
            dealTime(false, min, builder);
            setText(builder.toString());
            setVisibility(VISIBLE);
        } else {
            if (mListener != null) {
                mListener.onTimeFinish();
            }
            setVisibility(GONE);
            if (timer != null) {
                timer.cancel();
                timer = null;
            }
        }
    }

    private void dealTime(boolean isHour, int hms, StringBuilder builder) {
        if (hms < 10) {
            builder.append("0");
        }
        builder.append(hms);
        if (isHour) {
            builder.append("时");
        } else {
            builder.append("分");
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (timer != null) {
            timer.cancel();
        }
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
    }

    /*****
     * 开始计时
     */
    public void startTimer() {
        timer = new Timer();
        timer.schedule(new RemindTask(), 0, 1000);
    }

    class RemindTask extends TimerTask {

        @Override
        public void run() {
            handler.sendEmptyMessage(0);
        }
    }

    private Handler handler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
            showEffTime();
        }
    };

    public interface TimerListener {
        void onTimeFinish();
    }

}
