package com.rv.member.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.rv.member.R;
import com.rv.member.bean.MemberListBean;

import java.util.List;

public class MemberCompareView extends LinearLayout {

    private LinearLayout llContent;

    public MemberCompareView(Context context) {
        super(context);
    }

    public MemberCompareView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    private void initView() {
        View view = LayoutInflater.from(getContext()).inflate(R.layout.view_member_compare, null);
        llContent = view.findViewById(R.id.ll_content);
        addView(view);
    }

    private MemberRightItem itemView;

    public void setData(List<MemberListBean.MemberCard> lists) {
        if (lists != null && lists.size() > 0) {
            llContent.removeAllViews();
            for (MemberListBean.MemberCard memberCard : lists) {
                if (memberCard != null) {
                    itemView = new MemberRightItem(getContext());
                    itemView.setData(memberCard, lists.indexOf(memberCard));
                    llContent.addView(itemView);
                }
            }
        }
    }
}
