package com.rv.im.db.service;

import android.content.Context;

import com.rv.im.db.dao.CustomerDao;
import com.rv.im.db.table.Customer;

import java.util.List;

public class CustomerServiceImp implements ICustomerService {
    private CustomerDao dao = null;
    private static CustomerServiceImp instance = null;

    private CustomerServiceImp(Context context) {
        dao = CustomerDao.getInstance(context);
    }

    public static CustomerServiceImp getInstance(Context context) {
        if (instance == null) {
            instance = new CustomerServiceImp(context);
        }
        return instance;
    }

    @Override
    public List<Customer> getCustomerLists() {
        return dao.getAllCustomer();
    }

    @Override
    public void addCustomers(List<Customer> customers) {
        dao.addCustomers(customers);
    }

    public void release() {
        instance = null;
    }
}
