package com.rv.rvmine.traveler;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.adapter.TabAdapter;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.base.BaseWrapperFragment;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.ruiwenliu.wrapper.util.TransformationUtil;
import com.ruiwenliu.wrapper.util.glide.GlideOptions;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.horizontal.GallerySnapHelper;
import com.ruiwenliu.wrapper.weight.horizontal.SpaceItemDecoration;
import com.rv.rvmine.R;
import com.rv.rvmine.R2;
import com.rv.rvmine.fragment.MyReleaseAskFragment;
import com.rv.rvmine.fragment.MyReleasePatFragment;
import com.rv.rvmine.fragment.MyReleaseVideoFragment;
import com.xxrv.coupon.adapter.CouponMenuAdapter;
import com.xxrv.coupon.fragment.ExpiredCouponFragment;
import com.xxrv.coupon.fragment.UsedCouponFragment;
import com.xxrv.coupon.fragment.WaitCouponFragment;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * 我的发布
 */
public class MyReleaseActivity extends BaseStatusActivity<CommonPresenter> {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.release_viewPager)
    ViewPager mViewPager;


    private CouponMenuAdapter menuAdapter;
    private TabAdapter mAdapter;
    public final static int TYPE_PAT = 0;
    public final static int TYPE_VIDEO = 1;
    public final static int TYPE_ASK = 2;
    private MyReleasePatFragment myReleasePatFragment = null;
    private MyReleaseVideoFragment myReleaseVideoFragment = null;
    private MyReleaseAskFragment myReleaseAskFragment = null;

    public static Intent getIntent(Context context) {
        return new Intent(context, MyReleaseActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_my_release;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("我的发布");
        titleView.setImageResource(R.id.iv_title_right, R.drawable.myrelease_icon_setting);
        titleView.setChildClickListener(R.id.iv_title_right, new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                BaseWrapperFragment fragment = mAdapter.getCurrentFragment();
                fragment.changeShowDelete();
            }
        });
        initRecyclerView();
        initViewpager();
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    /**
     * 初始化RecyclerView
     */
    private void initRecyclerView() {
        recyclerView.setLayoutManager(new GridLayoutManager(mActivity, 3));
        menuAdapter = new CouponMenuAdapter();
        recyclerView.setAdapter(menuAdapter);
        recyclerView.addItemDecoration(new SpaceItemDecoration(5));
        GallerySnapHelper snapHelper = new GallerySnapHelper();
        snapHelper.attachToRecyclerView(recyclerView);
        List<String> list = new ArrayList<>();
//        list.add("我的拍拍");
//        list.add("我的短视频");
//        list.add("我的问答");

        menuAdapter.setNewData(list);
        menuAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                menuAdapter.setSelectItem(position);
                mViewPager.setCurrentItem(position);
                if (position == 0) {
                    myReleaseVideoFragment.changeShowNormal();
                    myReleaseAskFragment.changeShowNormal();
                } else if (position == 1) {
                    myReleasePatFragment.changeShowNormal();
                    myReleaseAskFragment.changeShowNormal();
                } else if (position == 2) {
                    myReleasePatFragment.changeShowNormal();
                    myReleaseVideoFragment.changeShowNormal();
                }
            }
        });
    }

    /**
     * 初始化Viewpager
     */
    private void initViewpager() {
        mAdapter = new TabAdapter(getSupportFragmentManager(), getListFragment());
        mViewPager.setAdapter(mAdapter);
        mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                menuAdapter.setSelectItem(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        mViewPager.setOffscreenPageLimit(mAdapter.getCount());
        menuAdapter.setSelectItem(0);
        mViewPager.setCurrentItem(0);
    }


    private List<BaseFragment> getListFragment() {
        myReleasePatFragment = MyReleasePatFragment.getInstance(TYPE_PAT);
        myReleaseVideoFragment = MyReleaseVideoFragment.getInstance(TYPE_VIDEO);
        myReleaseAskFragment = MyReleaseAskFragment.getInstance(TYPE_ASK);
        List<BaseFragment> list = new ArrayList<>();
        list.add(myReleasePatFragment);
//        list.add(myReleaseVideoFragment);
//        list.add(myReleaseAskFragment);
        return list;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        mAdapter.getCurrentFragment().onActivityResult(requestCode, resultCode, data);
    }
}
