package com.rv.home.rv.module.ui.main.home.other;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;

import com.alibaba.fastjson.JSON;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ApiConfig;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.adapter.SelectItemDefaultAdapter;
import com.rv.home.rv.module.ui.main.home.adapter.SelectItemOptionalAdapter;
import com.rv.home.rv.module.ui.main.home.bean.SelectItemBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * 选择随车物品
 */
public class SelectItemActivity extends BaseStatusActivity<CommonPresenter> {

    @BindView(R2.id.rv_content_default)
    RecyclerView rvContentDefault;
    @BindView(R2.id.rv_content_select)
    RecyclerView rvContentSelect;
    private SelectItemDefaultAdapter mDefaultAdapter;
    private SelectItemOptionalAdapter mOptionalAdapter;

    private List<SelectItemBean.DataBean> dataBean;
    private List<SelectItemBean.DataBean> selectData;
    private List<SelectItemBean.DataBean> oldSelectData;

    public static Intent getIntent(Context context, String selectItemList) {
        return new Intent(context, SelectItemActivity.class)
                .putExtra("selectitem", selectItemList);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_select_item;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("选择随车物品");
        String selectitem = intent.getStringExtra("selectitem");
        if (!TextUtils.isEmpty(selectitem)) {
            oldSelectData = JSON.parseArray(selectitem, SelectItemBean.DataBean.class);
        }

        //默认随车物品
        mDefaultAdapter = new SelectItemDefaultAdapter();
        rvContentDefault.setLayoutManager(new GridLayoutManager(mActivity, 3));
        rvContentDefault.setNestedScrollingEnabled(false);
        rvContentDefault.setAdapter(mDefaultAdapter);

        //可选随车物品
        mOptionalAdapter = new SelectItemOptionalAdapter();
        rvContentSelect.setLayoutManager(new LinearLayoutManager(mActivity, LinearLayoutManager.VERTICAL, false));
        rvContentSelect.setNestedScrollingEnabled(false);
        rvContentSelect.setAdapter(mOptionalAdapter);

        mOptionalAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                SelectItemBean.DataBean item = (SelectItemBean.DataBean) adapter.getItem(position);
                if (item.isSelect()) {
                    item.setSelect(false);
                } else {
                    item.setSelect(true);
                }
                mOptionalAdapter.notifyItemChanged(position);
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        loadDefaultData();
        loadSelectData();
    }

    private void loadSelectData() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("type", "3");
        mPresenter.getData(RvFrameConfig.HOST, 1, ApiConfig.HTTP_URL_UNAUTH_TYPEITEMS, SelectItemBean.class, map, headMap, true);
    }

    private void loadDefaultData() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("type", "1,2");
        mPresenter.getData(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URL_UNAUTH_TYPEITEMS, SelectItemBean.class, map, headMap, true);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                setDefaultData((SelectItemBean) result);
                break;

            case 1:
                setSelectData((SelectItemBean) result);
                break;
        }
    }

    private void setSelectData(SelectItemBean bean) {
        dataBean = bean.getData();

        if (oldSelectData != null && oldSelectData.size() > 0 && dataBean != null && dataBean.size() > 0) {
            for (int i = 0; i < oldSelectData.size(); i++) {
                for (int j = 0; j < dataBean.size(); j++) {
                    if (dataBean.get(j).getId().equals(oldSelectData.get(i).getId())) {
                        dataBean.get(j).setSelect(true);
                        break;
                    }
                }
            }
        }

        mOptionalAdapter.addData(dataBean);
    }


    private void setDefaultData(SelectItemBean bean) {
        mDefaultAdapter.addData(bean.getData());
    }

    @OnClick(R2.id.btn_item_ok)
    public void onViewClicked(View v) {
        int id = v.getId();
        if (id == R.id.btn_item_ok) {
            resultData();
            getIntent().putExtra("selectItem", JSON.toJSONString(selectData));
            setResult(RESULT_OK, getIntent());
            finish();
        }
    }

    private void resultData() {
        selectData = new ArrayList<>();
        if (dataBean != null && dataBean.size() > 0) {
            for (int i = 0; i < dataBean.size(); i++) {
                if (dataBean.get(i).isSelect()) {
                    selectData.add(dataBean.get(i));
                }
            }
        }
    }
}
