package com.rv.home.rv.module.ui.main.home.dialog;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.ruiwenliu.wrapper.dialog.BasePopupWindow;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.rv.component.utils.DisplayUtil;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.adapter.OrderCarPriceDetailAdapter;
import com.rv.home.rv.module.ui.main.home.bean.OrderCarPriceDetailBean;

/**
 * Desc:租车订单价格明细
 */

//public class OrderCarPriceDetailPw extends BasePopupWindow {
public class OrderCarPriceDetailPw extends BaseDialog {

    private final Activity activity;
    private OrderCarPriceDetailAdapter detailAdapter;
    private TextView tvTitle;

    public OrderCarPriceDetailPw(@NonNull Activity activity) {
        super(activity);
        this.activity = activity;
//        setClippingEnabled(true);
//        setOutsideTouchable(true);
//        setFocusable(true);
//        setHeight(ViewGroup.LayoutParams.WRAP_CONTENT);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.BOTTOM);
//        WindowManager wm = (WindowManager) activity.getSystemService(activity.WINDOW_SERVICE);
//        DisplayMetrics metrics = new DisplayMetrics();
//        wm.getDefaultDisplay().getMetrics(metrics);
//        if (metrics.heightPixels < DisplayUtil.dip2px(activity, 450)) {
//            setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.BOTTOM);
//
//        } else {
//            setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, DisplayUtil.dip2px(activity, 450), Gravity.BOTTOM);
//        }
    }

    @Override
    public int getViewLayout() {
        return R.layout.rv_pw_order_price_detail;
    }


    @Override
    public void helper(ViewHolder helper) {
        super.helper(helper);

        tvTitle = helper.getView(R.id.tv_title);
        RecyclerView recyclerView = helper.getView(R.id.recyclerView);
        recyclerView.setLayoutManager(new LinearLayoutManager(getDialogContext()));
        detailAdapter = new OrderCarPriceDetailAdapter();
        recyclerView.setAdapter(detailAdapter);

    }

    public void setNewData(OrderCarPriceDetailBean bean) {
        if (detailAdapter != null && bean != null) {
            tvTitle.setText(bean.getKey());
            detailAdapter.setNewData(bean.getChildren());
        }
    }

    @Override
    public void dismiss() {
        detailAdapter.setType(false);
        super.dismiss();
    }

//    @Override
//    public void showAsDropDown(View parent, int xoff, int yoff, int gravity) {
//        if (Build.VERSION.SDK_INT >= 24) {
//            Rect visibleFrame = new Rect();
//            parent.getGlobalVisibleRect(visibleFrame);
//            int height = parent.getResources().getDisplayMetrics().heightPixels - visibleFrame.bottom;
////            int height = anchor.getResources().getDisplayMetrics().heightPixels;
//            setHeight(height);
//        }
//        super.showAsDropDown(parent, xoff, yoff, gravity);
//    }
}
