package com.xxfc.discovery.adapter;

import android.support.v4.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.xxfc.discovery.R;

/**
 *
 */

public class DiscoveryMenuAdapter extends BaseQuickAdapter<String, BaseViewHolder> {

    public DiscoveryMenuAdapter() {
        super(R.layout.rv_item_discovery_menu);
    }

    private int selectPosition;

    @Override
    protected void convert(BaseViewHolder helper, String item) {
        helper.setText(R.id.tv_title, item);
        if (selectPosition == getPosition(item)) {

            helper.setTextColor(R.id.tv_title, ContextCompat.getColor(mContext, R.color.gray_FFB74B));
            helper.setGone(R.id.view_line, true);
        } else {
            helper.setTextColor(R.id.tv_title, ContextCompat.getColor(mContext, R.color.textMain));
            helper.setGone(R.id.view_line, false);
        }
    }

    public int getPosition(String item) {
        return mData.indexOf(item);
    }

    public void setSelectItem(int position) {
        this.selectPosition = position;
        notifyDataSetChanged();
    }

    /**
     * 获取选中的菜单
     *
     * @return
     */
    public int getSelectPosition() {
        return selectPosition;
    }
}
