package com.base.utils.ui.dialog;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;

import com.base.utils.R;
import com.orhanobut.dialogplus.DialogPlus;
import com.orhanobut.dialogplus.DialogPlusBuilder;
import com.orhanobut.dialogplus.ViewHolder;

/**
 * 扩展 对话框工具
 * https://github.com/orhanobut/dialogplus
 */

public class DialogPlusUtil {

    public static DialogPlusBuilder getDialogPlus(Context context,int layoutRes) {
        return DialogPlus.newDialog(context)
                .setContentHolder(new ViewHolder(layoutRes))
                .setContentWidth(ViewGroup.LayoutParams.MATCH_PARENT)
                .setContentHeight(ViewGroup.LayoutParams.WRAP_CONTENT)
                .setContentBackgroundResource(R.drawable.resource_drawable_selector_radius_background);
    }
    public static DialogPlusBuilder getDialogPlus(Context context, View layout) {
        return DialogPlus.newDialog(context)
                .setContentHolder(new ViewHolder(layout))
                .setContentWidth(ViewGroup.LayoutParams.MATCH_PARENT)
                .setContentHeight(ViewGroup.LayoutParams.WRAP_CONTENT)
                .setContentBackgroundResource(R.drawable.resource_drawable_selector_radius_background);
    }


}
