package com.base.utils.tools.exception;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.base.utils.R;
import com.base.utils.base.BaseActivity;
import com.base.utils.eventbusmodel.EventRestartApp;

import org.greenrobot.eventbus.EventBus;

/**
 * 展示异常
 * 关闭后重启程序
 */

public class ExceptionCatchActivity extends BaseActivity {
    final public static String INTENT_DATA_KEY = "Exception";

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.utils_exception_catch_activity);
        onData();
        onView();
    }

    private ImageView closeImageView;
    private TextView exceptionTextView;

    private Throwable throwable;


    @Override
    public void onData() {
        throwable = (Throwable) getIntent().getSerializableExtra(ExceptionCatchActivity.INTENT_DATA_KEY);
    }

    @Override
    public void onView() {
        closeImageView = (ImageView) findViewById(R.id.exception_catch_close);
        closeImageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                EventBus.getDefault().post(new EventRestartApp(EventRestartApp.Type.TYPE_RESTART_EXCEPTION));
                finish();
            }
        });
        exceptionTextView = (TextView) findViewById(R.id.exception_catch_text);
        exceptionTextView.setText(throwable.toString());
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            EventBus.getDefault().post(new EventRestartApp(EventRestartApp.Type.TYPE_RESTART_EXCEPTION));
            finish();
        }
        return super.onKeyDown(keyCode, event);
    }
}
