package com.base.utils.tools.android;

import android.app.Activity;
import android.app.Dialog;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

/**
 * 手机状态栏
 */
public class StatusBarUtil {
    //设置状态栏透明
    public static void setStatusTranslucent(Activity activity){
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP) {
            activity.  getWindow().setFlags(
                    WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS,
                    WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
        }
    }

    /**
     * 设置全屏
     *
     * @param activity 上下文
     * @param enable   是否开启
     */
    public static void setFullScreen(Activity activity, boolean enable) {
        if (enable) {
//            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
//            lp.flags |= WindowManager.LayoutParams.FLAG_FULLSCREEN;
//            activity.getWindow().setAttributes(lp);
//            activity.getWindow().addFlags(WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS);
            activity.getWindow().setFlags(
                    WindowManager.LayoutParams.FLAG_FULLSCREEN,
                    WindowManager.LayoutParams.FLAG_FULLSCREEN
            );
        } else {
            activity.getWindow().clearFlags(
                    WindowManager.LayoutParams.FLAG_FULLSCREEN
            );
        }
    }

    /**
     * 隐藏顶部状态栏、底部虚拟导航栏  This snippet hides the system bars
     * Set the IMMERSIVE flag.
     * Set the content to appear under the system bars so that the content
     * doesn't resize when the system bars hide and show.
     */
    public static void hideSystemUI(Activity activity) {
        activity.getWindow().getDecorView().setSystemUiVisibility(
                // hide nav bar
                View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                        // hide status bar
                        | View.SYSTEM_UI_FLAG_FULLSCREEN);
    }

    /**
     * 显示顶部状态栏、底部虚拟导航栏
     * This snippet shows the system bars. It does this by removing all the flags
     * except for the ones that make the content appear under the system bars.
     */

    public static void showSystemUI(Activity activity) {
        activity.getWindow().getDecorView().setSystemUiVisibility(
                // show nav bar
                View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                        // show status bar
                        | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN);
    }


    /**
     * api 22及以上
     * 设置顶部状态栏颜色
     *
     * @param activity
     * @param colorResId
     */
    public static void setWindowStatusBarColorWithActivity(Activity activity, int colorResId) {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                Window window = activity.getWindow();
                window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                //顶部状态栏
                window.setStatusBarColor(ContextCompat.getColor(activity, colorResId));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * api 22及以上
     * 设置底部导航栏颜色
     *
     * @param activity
     * @param colorResId
     */
    public static void setNavigationBarColorWithActivity(Activity activity, int colorResId) {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                Window window = activity.getWindow();
                window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                //底部导航栏
                window.setNavigationBarColor(ContextCompat.getColor(activity, colorResId));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * api 22及以上
     * 设置顶部状态栏颜色
     *
     * @param dialog
     * @param colorResId
     */
    public static void setWindowStatusBarColorWithDialog(Dialog dialog, int colorResId) {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                Window window = dialog.getWindow();
                if (window != null) {
                    window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                    //顶部状态栏
                    window.setStatusBarColor(ContextCompat.getColor(dialog.getContext(), colorResId));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * api 22及以上
     * 设置顶部状态栏颜色
     *
     * @param dialog
     * @param colorResId
     */
    public static void setNavigationBarColorWithDialog(Dialog dialog, int colorResId) {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                Window window = dialog.getWindow();
                if (window != null) {
                    window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                    //底部导航栏
                    window.setNavigationBarColor(ContextCompat.getColor(dialog.getContext(), colorResId));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
