package com.ruiwenliu.wrapper.browse;

import android.os.Bundle;
import android.support.annotation.IntegerRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.base.utils.base.BaseFragment;
import com.base.utils.ui.image.pinch.PinchImageView;
import com.ruiwenliu.wrapper.R;
import com.ruiwenliu.wrapper.dialog.BottomPromptTwoDialog;
import com.ruiwenliu.wrapper.util.ImageFileUtil;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;

import java.util.Objects;

/**
 * 浏览图片的碎片
 * FragmentImageBrowse
 */

public class FragmentImageBrowse2 extends BaseFragment {
    final private static String KEY_IMAGE_INT = "image_int";
    final private static String KEY_IMAGE_STRING = "image_string";

    private int getImageInt() {
        if (getArguments() == null) return 0;
        return getArguments().getInt(FragmentImageBrowse2.KEY_IMAGE_INT);
    }

    private String getImageString() {
        if (getArguments() == null) return "";
        return getArguments().getString(FragmentImageBrowse2.KEY_IMAGE_STRING);
    }

    public static FragmentImageBrowse2 getInstance(@IntegerRes int imageRes) {
        FragmentImageBrowse2 instance = new FragmentImageBrowse2();
        Bundle bundle = new Bundle();
        bundle.putInt(FragmentImageBrowse2.KEY_IMAGE_INT, imageRes);
        instance.setArguments(bundle);
        return instance;
    }

    public static FragmentImageBrowse2 getInstance(String imageUrl) {
        FragmentImageBrowse2 instance = new FragmentImageBrowse2();
        Bundle bundle = new Bundle();
        bundle.putString(FragmentImageBrowse2.KEY_IMAGE_STRING, imageUrl);
        instance.setArguments(bundle);
        return instance;
    }

    PinchImageView pinchImageView;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_image_browse, container, false);
        pinchImageView = view.findViewById(R.id.image_browse_pinch_image_view);
        onData();
        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        onView();
    }

    @Override
    public void onData() {
    }

    @Override
    public void onView() {
        if (getImageInt() != 0) {
            pinchImageView.setImageResource(getImageInt());
        } else {
            GlideManager.getInstance(baseContext).loadImage(getImageString(), pinchImageView);
        }
        pinchImageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (Objects.requireNonNull(getActivity()) != null)
                    Objects.requireNonNull(getActivity()).finish();

            }
        });

        pinchImageView.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {

                new BottomPromptTwoDialog(baseContext) {
                    @Override
                    public void helper(ViewHolder helper) {
                        super.helper(helper);
                        helper.setOnClickListener(new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                int i = v.getId();
                                if (i == R.id.btn1) {

                                    if (TextUtils.isEmpty(getImageString())) {
                                        return;
                                    }
                                    if (getImageString().toLowerCase().endsWith("gif")) {// 保存Gif
                                        ImageFileUtil.downImageToGallery(baseContext, getImageString());
                                    } else {// 保存图片
                                        ImageFileUtil.downImageToGallery(baseContext, getImageString());
                                    }
                                    dismiss();
                                } else if (i == R.id.btn2) {
                                    dismiss();
                                }

                            }
                        }, R.id.btn1, R.id.btn2);


                    }
                }.show();
                return false;
            }
        });
    }
}
