package com.base.animset.util;


import com.base.animset.nifty.BaseNiftyEffects;
import com.base.animset.nifty.Flip;
import com.base.animset.nifty.Jelly;
import com.base.animset.nifty.Scale;
import com.base.animset.nifty.SlideIn;
import com.base.animset.nifty.SlideOnTop;
import com.base.animset.nifty.Standard;
import com.base.animset.nifty.ThumbSlider;

/*
 * Copyright 2014 gitonway
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
public enum NiftyEffects {
    standard(Standard.class),
    slideOnTop(SlideOnTop.class),
    flip(Flip.class),
    slideIn(SlideIn.class),
    jelly(Jelly.class),
    thumbSlider(ThumbSlider.class),
    scale(Scale.class);


    private Class<? extends BaseNiftyEffects> effectsClazz;

    NiftyEffects(Class<? extends BaseNiftyEffects> mclass) {
        effectsClazz = mclass;
    }

    public BaseNiftyEffects getAnimator() {
        BaseNiftyEffects bEffects=null;
        try {
            bEffects = effectsClazz.newInstance();
        } catch (ClassCastException e) {
            throw new Error("Can not init animatorClazz instance");
        } catch (InstantiationException e) {
            // TODO Auto-generated catch block
            throw new Error("Can not init animatorClazz instance");
        } catch (IllegalAccessException e) {
            // TODO Auto-generated catch block
            throw new Error("Can not init animatorClazz instance");
        }
        return bEffects;
    }
}
